/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.inventory.KeyRingInventory;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class KeyRingItem
extends ModItem {
    private static final String USED_ON_CHEST = "usedOnChest";
    public static final String IS_OPEN = "isOpen";
    private int keyRingGuiID = 3;

    public KeyRingItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77637_a(Treasure.TREASURE_TAB);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (WorldInfo.isServerSide(worldIn)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a(USED_ON_CHEST, false);
            stack.func_77978_p().func_74757_a(IS_OPEN, false);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (WorldInfo.isServerSide(world)) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (!heldItem.func_77942_o()) {
                heldItem.func_77982_d(new NBTTagCompound());
            }
            heldItem.func_77978_p().func_74757_a(USED_ON_CHEST, false);
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.key_ring", (Object[])new Object[]{TextFormatting.GOLD}));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean isKeyBroken = false;
        if (WorldInfo.isClientSide(worldIn)) {
            return EnumActionResult.FAIL;
        }
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block instanceof TreasureChestBlock) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te == null || !(te instanceof AbstractTreasureChestTileEntity)) {
                Treasure.logger.warn("Null or incorrect TileEntity");
                return EnumActionResult.FAIL;
            }
            AbstractTreasureChestTileEntity tcte = (AbstractTreasureChestTileEntity)te;
            ItemStack heldItem = player.func_184586_b(hand);
            if (!heldItem.func_77942_o()) {
                heldItem.func_77982_d(new NBTTagCompound());
            }
            heldItem.func_77978_p().func_74757_a(USED_ON_CHEST, true);
            if (!tcte.hasLocks()) {
                return EnumActionResult.SUCCESS;
            }
            try {
                KeyRingInventory inv = new KeyRingInventory(heldItem);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack keyStack = inv.func_70301_a(i);
                    if (keyStack == null || keyStack.func_77973_b() == Items.field_190931_a) continue;
                    KeyItem key = (KeyItem)keyStack.func_77973_b();
                    Treasure.logger.debug("Using key from keyring: {}", (Object)key.func_77658_a());
                    boolean breakKey = true;
                    LockState lockState = null;
                    lockState = key.fitsFirstLock(tcte.getLockStates());
                    Treasure.logger.debug("key fits lock: {}", (Object)lockState);
                    if (lockState == null) continue;
                    if (key.unlock(lockState.getLock())) {
                        LockItem lock = lockState.getLock();
                        lockState.setLock(null);
                        worldIn.func_184133_a(player, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
                        tcte.sendUpdates();
                        if (TreasureConfig.KEYS_LOCKS.enableLockDrops) {
                            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((Item)lock));
                        }
                        breakKey = false;
                    }
                    if (breakKey) {
                        if (key.isBreakable() && TreasureConfig.KEYS_LOCKS.enableKeyBreaks) {
                            keyStack.func_190918_g(1);
                            player.func_145747_a((ITextComponent)new TextComponentString("Key broke."));
                            worldIn.func_184133_a(player, pos, SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 0.3f, 0.6f);
                            isKeyBroken = true;
                            if (keyStack.func_190916_E() > 0) {
                                keyStack.func_77964_b(0);
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("Failed to unlock."));
                        }
                    }
                    if (key.func_77645_m() && !isKeyBroken) {
                        keyStack.func_77972_a(1, (EntityLivingBase)player);
                    } else {
                        Treasure.logger.debug("Key in keyring is NOT damageable.");
                    }
                    ItemStackHelper.func_191282_a((NBTTagCompound)heldItem.func_77978_p(), inv.getItems());
                    heldItem.func_77978_p().func_74757_a(USED_ON_CHEST, true);
                    break;
                }
            }
            catch (Exception e) {
                Treasure.logger.error("error: ", (Throwable)e);
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (WorldInfo.isClientSide(worldIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        boolean useOnChest = false;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77942_o()) {
            useOnChest = stack.func_77978_p().func_74767_n(USED_ON_CHEST);
        }
        if (useOnChest) {
            stack.func_77978_p().func_74757_a(USED_ON_CHEST, false);
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        BlockPos pos = playerIn.func_180425_c();
        playerIn.openGui((Object)Treasure.instance, this.getKeyRingGuiID(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        if (item.func_77978_p().func_74767_n(IS_OPEN)) {
            return false;
        }
        return super.onDroppedByPlayer(item, player);
    }

    public int getKeyRingGuiID() {
        return this.keyRingGuiID;
    }

    public void setKeyRingGuiID(int keyRingGuiID) {
        this.keyRingGuiID = keyRingGuiID;
    }
}

