/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.loot.LootTableMaster;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class TreasureLootTableMaster
extends LootTableMaster {
    private static final String CUSTOM_LOOT_TABLES_RESOURCE_PATH = "/loot_tables/";
    private static final String CUSTOM_LOOT_TABLES_PATH = "loot_tables";
    public static final String CUSTOM_LOOT_TABLE_KEY = "CUSTOM";
    private final Map<SpecialLootTables, LootTable> SPECIAL_LOOT_TABLES_MAP = new HashMap<SpecialLootTables, LootTable>();
    private final Table<String, Rarity, List<ResourceLocation>> CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE = HashBasedTable.create();
    private final Table<String, Rarity, List<LootTable>> CHEST_LOOT_TABLES_TABLE = HashBasedTable.create();
    private static final List<String> SPECIAL_CHEST_LOOT_TABLE_FOLDER_LOCATIONS = ImmutableList.of((Object)"chests/special");
    private static final List<String> CHEST_LOOT_TABLE_FOLDER_LOCATIONS = ImmutableList.of((Object)"chests/common", (Object)"chests/uncommon", (Object)"chests/scarce", (Object)"chests/rare", (Object)"chests/epic");
    private static final List<String> NON_CHEST_LOOT_TABLE_FOLDER_LOCATIONS = ImmutableList.of((Object)"treasure", (Object)"armor", (Object)"food", (Object)"items", (Object)"potions", (Object)"tools");

    public TreasureLootTableMaster(IMod mod, String resourcePath, String folderName) {
        super(mod, resourcePath, folderName);
        if (TreasureConfig.MOD.enableDefaultLootTablesCheck) {
            this.buildAndExpose("treasure2");
            for (String foreignModID : TreasureConfig.FOREIGN_MODS.enableForeignModIDs) {
                if (!Loader.isModLoaded((String)foreignModID)) continue;
                this.buildAndExpose(foreignModID);
            }
        }
        for (Rarity r : Rarity.values()) {
            this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.put((Object)CUSTOM_LOOT_TABLE_KEY, (Object)r, new ArrayList());
            this.CHEST_LOOT_TABLES_TABLE.put((Object)CUSTOM_LOOT_TABLE_KEY, (Object)r, new ArrayList());
        }
    }

    public void clear() {
        super.getLootTablesMap().clear();
        super.getLootTablesResourceLocationMap().clear();
        this.CHEST_LOOT_TABLES_TABLE.clear();
        this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.clear();
        this.SPECIAL_LOOT_TABLES_MAP.clear();
    }

    private void buildAndExpose(String modID) {
        this.buildAndExpose(CUSTOM_LOOT_TABLES_RESOURCE_PATH, modID, CHEST_LOOT_TABLE_FOLDER_LOCATIONS);
        this.buildAndExpose(CUSTOM_LOOT_TABLES_RESOURCE_PATH, modID, NON_CHEST_LOOT_TABLE_FOLDER_LOCATIONS);
        this.buildAndExpose(CUSTOM_LOOT_TABLES_RESOURCE_PATH, modID, SPECIAL_CHEST_LOOT_TABLE_FOLDER_LOCATIONS);
    }

    public void register(String modID) {
        Path path;
        for (String location : SPECIAL_CHEST_LOOT_TABLE_FOLDER_LOCATIONS) {
            List<ResourceLocation> specialLocations = this.getLootTablesResourceLocations(modID, location);
            for (ResourceLocation loc : specialLocations) {
                path = Paths.get(loc.func_110623_a(), new String[0]);
                LootTable lootTable = this.getLootTableManager().getLootTableFromLocation(loc);
                SpecialLootTables specialLootTables = SpecialLootTables.valueOf(Files.getNameWithoutExtension((String)path.getName(path.getNameCount() - 1).toString().toUpperCase()));
                this.SPECIAL_LOOT_TABLES_MAP.put(specialLootTables, lootTable);
            }
        }
        for (String location : CHEST_LOOT_TABLE_FOLDER_LOCATIONS) {
            List<ResourceLocation> locs = this.getLootTablesResourceLocations(modID, location);
            for (ResourceLocation loc : locs) {
                path = Paths.get(loc.func_110623_a(), new String[0]);
                Treasure.logger.debug("path to resource loc -> {}", (Object)path.toString());
                Rarity key = Rarity.valueOf(path.getName(path.getNameCount() - 2).toString().toUpperCase());
                ((List)this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).add(loc);
                LootTable lootTable = this.getLootTableManager().getLootTableFromLocation(loc);
                ((List)this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).add(lootTable);
                Treasure.logger.debug("tabling loot table: {} {} -> {}", (Object)CUSTOM_LOOT_TABLE_KEY, (Object)key, (Object)loc);
            }
        }
    }

    public List<LootTable> getLootTableByRarity(Rarity rarity) {
        ArrayList<LootTable> tables = new ArrayList<LootTable>();
        Map mapOfLootTables = this.CHEST_LOOT_TABLES_TABLE.column((Object)rarity);
        for (Map.Entry n : mapOfLootTables.entrySet()) {
            Treasure.logger.debug("Adding table entry to loot table list -> {} {}: size {}", (Object)rarity, n.getKey(), (Object)((List)n.getValue()).size());
            tables.addAll((Collection)n.getValue());
        }
        return tables;
    }

    public List<ResourceLocation> getLootTableResourceByRarity(Rarity rarity) {
        ArrayList<ResourceLocation> tables = new ArrayList<ResourceLocation>();
        Map mapOfLootTableResourceLocations = this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.column((Object)rarity);
        for (Map.Entry n : mapOfLootTableResourceLocations.entrySet()) {
            tables.addAll((Collection)n.getValue());
        }
        return tables;
    }

    public LootTable getSpecialLootTable(SpecialLootTables table) {
        LootTable lootTable = this.SPECIAL_LOOT_TABLES_MAP.get((Object)table);
        return lootTable;
    }

    public Table<String, Rarity, List<LootTable>> getChestLootTablesTable() {
        return this.CHEST_LOOT_TABLES_TABLE;
    }

    public static enum SpecialLootTables {
        WITHER_CHEST,
        SKULL_CHEST,
        GOLD_SKULL_CHEST,
        CAULDRON_CHEST,
        CLAM_CHEST,
        OYSTER_CHEST,
        SILVER_WELL,
        GOLD_WELL,
        WHITE_PEARL_WELL,
        BLACK_PEARL_WELL;

    }
}

