/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.world.gen.structure;

import com.google.common.collect.ImmutableList;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayManager;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.treasure2.Treasure;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class TreasureDecayManager
extends DecayManager {
    private static List<String> FOLDER_LOCATIONS = ImmutableList.of((Object)"");

    public TreasureDecayManager(IMod mod, String resourceFolder) {
        super(mod, resourceFolder);
        this.buildAndExpose(this.getBaseResourceFolder(), "treasure2", FOLDER_LOCATIONS);
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void register(String modID) {
        String location = "";
        Treasure.logger.debug("registering ruleset files from location -> {}", (Object)location);
        List<ResourceLocation> locs = this.getResourceLocations(modID, location);
        for (ResourceLocation loc : locs) {
            Path path = Paths.get(loc.func_110623_a(), new String[0]);
            if (Treasure.logger.isDebugEnabled()) {
                Treasure.logger.debug("path to ruleset resource loc -> {}", (Object)path.toString());
            }
            Treasure.logger.debug("attempted to load custom ruleset file  with key -> {}", (Object)loc.toString());
            IDecayRuleSet ruleset = this.load(loc);
            if (ruleset == null) {
                Treasure.logger.debug("Unable to locate ruleset file -> {}", (Object)loc.toString());
                continue;
            }
            Treasure.logger.debug("loaded custom ruleset file  with key -> {}", (Object)loc.toString());
        }
    }
}

