/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.worldgen;

import com.google.common.base.Predicate;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;

public class GemOreWorldGenerator
implements ITreasureWorldGenerator {
    private WorldGenMinable sapphireGenerator;
    private WorldGenMinable rubyGenerator;
    private int chunksSinceLastOre = 1;

    public GemOreWorldGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to instantiate GemOreGenerator:", (Throwable)e);
        }
        this.sapphireGenerator = new WorldGenMinable(TreasureBlocks.SAPPHIRE_ORE.func_176223_P(), TreasureConfig.GEMS_ORES.sapphireOreVeinSize);
        this.rubyGenerator = new WorldGenMinable(TreasureBlocks.RUBY_ORE.func_176223_P(), TreasureConfig.GEMS_ORES.rubyOreVeinSize);
    }

    @Override
    public void init() {
        this.chunksSinceLastOre = 0;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList().contains(world.field_73011_w.getDimension())) {
            this.generate(world, random, chunkX, chunkZ);
        }
    }

    private void generate(World world, Random random, int chunkX, int chunkZ) {
        int maxY;
        ++this.chunksSinceLastOre;
        int xSpawn = chunkX * 16;
        int zSpawn = chunkZ * 16;
        int flip = RandomHelper.randomInt(0, 1);
        double prob = 0.0;
        int veinsPerChunk = 0;
        int minY = 0;
        WorldGenMinable gen = null;
        if (flip == 0) {
            prob = TreasureConfig.GEMS_ORES.sapphireGenProbability;
            veinsPerChunk = TreasureConfig.GEMS_ORES.sapphireOreVeinsPerChunk;
            maxY = TreasureConfig.GEMS_ORES.sapphireOreMaxY;
            minY = TreasureConfig.GEMS_ORES.sapphireOreMinY;
            gen = this.sapphireGenerator;
        } else {
            prob = TreasureConfig.GEMS_ORES.rubyGenProbability;
            veinsPerChunk = TreasureConfig.GEMS_ORES.rubyOreVeinsPerChunk;
            maxY = TreasureConfig.GEMS_ORES.rubyOreMaxY;
            minY = TreasureConfig.GEMS_ORES.rubyOreMinY;
            gen = this.rubyGenerator;
        }
        if (!RandomHelper.checkProbability(random, prob)) {
            return;
        }
        for (int veinIndex = 0; veinIndex < veinsPerChunk; ++veinIndex) {
            int ySpawn = random.nextInt(maxY) + minY;
            gen.func_180709_b(world, random, new BlockPos(xSpawn += random.nextInt(16), ySpawn, zSpawn += random.nextInt(16)));
        }
        this.chunksSinceLastOre = 0;
        GenDataPersistence savedData = GenDataPersistence.get(world);
        if (savedData != null) {
            savedData.func_76185_a();
        }
    }

    private void generateNether(World world, Random random, int i, int j) {
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    public int getChunksSinceLastOre() {
        return this.chunksSinceLastOre;
    }

    public void setChunksSinceLastOre(int chunksSinceLastOre) {
        this.chunksSinceLastOre = chunksSinceLastOre;
    }

    static class StonePredicate
    implements Predicate<IBlockState> {
        private StonePredicate() {
        }

        public boolean apply(IBlockState state) {
            if (state != null && state.func_177230_c() == Blocks.field_150348_b) {
                BlockStone.EnumType blockstone$enumtype = (BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a);
                return blockstone$enumtype.func_190912_e();
            }
            return false;
        }
    }

    public class WorldGenMinable
    extends WorldGenerator {
        private final IBlockState oreBlock;
        private final int numberOfBlocks;
        private final Predicate<IBlockState> predicate;

        public WorldGenMinable(IBlockState state, int blockCount) {
            this(state, blockCount, new StonePredicate());
        }

        public WorldGenMinable(IBlockState state, int blockCount, Predicate<IBlockState> p_i45631_3_) {
            this.oreBlock = state;
            this.numberOfBlocks = blockCount;
            this.predicate = p_i45631_3_;
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            float f = rand.nextFloat() * (float)Math.PI;
            double d0 = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d1 = (float)(position.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d2 = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d3 = (float)(position.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d4 = position.func_177956_o() + rand.nextInt(3) - 2;
            double d5 = position.func_177956_o() + rand.nextInt(3) - 2;
            for (int i = 0; i < this.numberOfBlocks; ++i) {
                float f1 = (float)i / (float)this.numberOfBlocks;
                double d6 = d0 + (d1 - d0) * (double)f1;
                double d7 = d4 + (d5 - d4) * (double)f1;
                double d8 = d2 + (d3 - d2) * (double)f1;
                double d9 = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
                double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
                double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
                int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
                int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
                int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
                int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
                int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
                int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
                for (int l1 = j; l1 <= i1; ++l1) {
                    double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                    if (!(d12 * d12 < 1.0)) continue;
                    for (int i2 = k; i2 <= j1; ++i2) {
                        double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                        if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                        for (int j2 = l; j2 <= k1; ++j2) {
                            BlockPos blockpos;
                            IBlockState state;
                            double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                            if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(l1, i2, j2))).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, this.predicate)) continue;
                            worldIn.func_180501_a(blockpos, this.oreBlock, 2);
                        }
                    }
                }
            }
            return true;
        }
    }
}

