/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.slime.Entity_SpecialSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityLemonSlime
extends Entity_SpecialSlime {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityLemonSlime.GET_TEXTURE_PATH("lemon"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(15132769);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityLemonSlime.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Redstone dust", Items.field_151137_ax, 1);
        loot.addUncommonDrop("uncommon", "Slime color", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.YELLOW.func_176767_b()));
    }

    public EntityLemonSlime(World world) {
        super(world);
        this.getSpecialData().setImmuneToFire(true);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityLemonSlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void applyTypeAttributes() {
        this.slimeExperienceValue += 2;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 2.0 * (double)size);
    }

    @Override
    protected void onTypeAttack(Entity target) {
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, false));
        double power = 1.0;
        double vX = this.field_70165_t - target.field_70165_t;
        double vZ = this.field_70161_v - target.field_70161_v;
        double vH = Math.sqrt(vX * vX + vZ * vZ);
        this.field_70159_w = vX / vH * power + this.field_70159_w * 0.2;
        this.field_70181_x = 0.42 * power;
        this.field_70179_y = vZ / vH * power + this.field_70179_y * 0.2;
        this.field_70160_al = true;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }
}

