/*
 * Decompiled with CFR 0.152.
 */
package levelup2.api;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import levelup2.api.ICharacterClass;
import levelup2.api.IPlayerSkill;
import levelup2.api.PlayerSkillStorage;
import levelup2.skills.SkillRegistry;
import levelup2.util.ClassProperties;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class BaseClass
implements ICharacterClass {
    private ResourceLocation className;
    private IPlayerSkill bonusSkill;
    private List<PlayerSkillStorage> applicableSkills;

    public BaseClass(ResourceLocation location, IPlayerSkill spec, List<PlayerSkillStorage> skillBonuses) {
        this.className = location;
        this.bonusSkill = spec;
        this.applicableSkills = skillBonuses;
    }

    public static BaseClass fromProperties(ClassProperties props) {
        ResourceLocation location = props.getClassName();
        IPlayerSkill skill = SkillRegistry.getSkillFromName(props.getSpecSkill());
        List<PlayerSkillStorage> skills = props.getBonusSkills();
        return new BaseClass(location, skill, skills);
    }

    public BaseClass fromJson(JsonObject json) {
        ResourceLocation location = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"name"));
        IPlayerSkill bonus = SkillRegistry.getSkillFromName(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"bonus")));
        ArrayList skillBonuses = Lists.newArrayList();
        for (JsonElement obj : JsonUtils.func_151214_t((JsonObject)json, (String)"skills")) {
            skillBonuses.add(PlayerSkillStorage.fromJson(obj.getAsJsonObject()));
        }
        return new BaseClass(location, bonus, skillBonuses);
    }

    @Override
    @Nonnull
    public ResourceLocation getClassName() {
        return this.className;
    }

    @Override
    @Nonnull
    public IPlayerSkill getSpecializationSkill() {
        return this.bonusSkill;
    }

    @Override
    public List<PlayerSkillStorage> getSkillBonuses() {
        return this.applicableSkills;
    }
}

