/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.util.IntVec2;
import hunternif.mc.atlas.util.ListMapValueIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DimensionMarkersData {
    private final MarkersData parent;
    private final int dimension;
    private int size = 0;
    private final Map<IntVec2, List<Marker>> chunkMap = new ConcurrentHashMap<IntVec2, List<Marker>>(2, 0.75f, 2);
    private final Values values = new Values();
    private final Map<Thread, IntVec2> thread2KeyMap = new ConcurrentHashMap<Thread, IntVec2>(2, 0.75f, 2);

    private IntVec2 getKey() {
        return this.thread2KeyMap.computeIfAbsent(Thread.currentThread(), k -> new IntVec2(0.0, 0.0));
    }

    public DimensionMarkersData(MarkersData parent, int dimension) {
        this.parent = parent;
        this.dimension = dimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public List<Marker> getMarkersAtChunk(int x, int z) {
        return this.chunkMap.get(this.getKey().set(x, z));
    }

    public void insertMarker(Marker marker) {
        IntVec2 key = this.getKey().set(marker.getChunkX() / 8, marker.getChunkZ() / 8);
        List<Marker> list = this.chunkMap.get(key);
        if (list == null) {
            list = new CopyOnWriteArrayList<Marker>();
            this.chunkMap.put(key.clone(), list);
        }
        boolean inserted = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getZ() <= marker.getZ()) continue;
            list.add(i, marker);
            inserted = true;
            break;
        }
        if (!inserted) {
            list.add(marker);
        }
        ++this.size;
        this.parent.func_76185_a();
    }

    public boolean removeMarker(Marker marker) {
        --this.size;
        return this.getMarkersAtChunk(marker.getChunkX() / 8, marker.getChunkZ() / 8).remove(marker);
    }

    public Collection<Marker> getAllMarkers() {
        return this.values;
    }

    private class Values
    extends AbstractCollection<Marker> {
        private Values() {
        }

        @Override
        public Iterator<Marker> iterator() {
            return new ListMapValueIterator(DimensionMarkersData.this.chunkMap).setImmutable(true);
        }

        @Override
        public int size() {
            return DimensionMarkersData.this.size;
        }
    }
}

