/*
 * Decompiled with CFR 0.152.
 */
package gaia;

import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="grimoireofgaia", category="")
public class GaiaConfig {
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu0.general")
    @Config.Comment(value={"Spawn Rates"})
    public static final General GENERAL = new General();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu1.spawns")
    @Config.Comment(value={"Spawn Options"})
    public static final Spawn SPAWN = new Spawn();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu2.attributes")
    @Config.Comment(value={"Attributes"})
    public static final Attributes ATTRIBUTES = new Attributes();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu3.damage")
    @Config.Comment(value={"Base Damage"})
    public static final Damage DAMAGE = new Damage();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu4.defense")
    @Config.Comment(value={"Base Damage Cap"})
    public static final Defense DEFENSE = new Defense();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu5.options")
    public static final Options OPTIONS = new Options();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu6.debug")
    @Config.Comment(value={"Debug"})
    public static final Debug DEBUG = new Debug();
    @Config.LangKey(value="configgui.grimoireofgaia.category.Menu7.dimensions")
    @Config.Comment(value={"Dimensional Settings"})
    public static final Dimensions DIMENSIONS = new Dimensions();

    private GaiaConfig() {
    }

    public static class Dimensions {
        @Config.LangKey(value="configgui.grimoireofgaia.category.dimensions.Menu0.Dimension_Blacklist")
        @Config.Comment(value={"Disables Gaia mobs from spawning in the specified dimension ids"})
        public int[] dimensionBlacklist = new int[0];
    }

    public static class Debug {
        @Config.LangKey(value="configgui.grimoireofgaia.category.debug.Menu0.Ore_Unity")
        @Config.Comment(value={"Mobs can drop nuggets/shards from other mods. (Disable if you encounter issues)"})
        public boolean oreUnity = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.debug.Menu1.Debug_Spawn")
        @Config.Comment(value={"Disables all non-Gaia mobs from spawning"})
        @Config.RequiresMcRestart
        public boolean debugCommands = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.debug.Menu2.Debug_Commands")
        @Config.Comment(value={"Enables developer commands"})
        @Config.RequiresMcRestart
        public boolean debugSpawn = false;
    }

    public static class Options {
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu0.Enable_Spawn")
        @Config.Comment(value={"Enable Gaia mobs to spawn"})
        @Config.RequiresMcRestart
        public boolean enableSpawn = true;
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu1.Passive_Hostile_Mobs")
        @Config.Comment(value={"Hostile day mobs will no longer attack players on sight"})
        public boolean passiveHostileMobs = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu2.Passive_Hostile_All_Mobs")
        @Config.Comment(value={"All mobs are now hostile"})
        public boolean passiveHostileAllMobs = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu3.AdditionalOre")
        @Config.Comment(value={"Gaia mobs can now drop Copper and Silver Nuggets"})
        public boolean additionalOre = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu4.StrafingArchers")
        @Config.Comment(value={"Archers will strafe and avoid attacks (like Skeletons)"})
        public boolean strafingArchers = true;
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu5.DisableDrops")
        @Config.Comment(value={"Disable drops not using loot tables."})
        public boolean disableDrops = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.options.Menu6.DisableInvisibility")
        @Config.Comment(value={"Disable mobs that use the Invisibility status effect when far from a player."})
        public boolean disableInvisibility = false;
    }

    public static class Defense {
        @Config.LangKey(value="configgui.grimoireofgaia.category.defense.Tier1baseDefense")
        @Config.Comment(value={"Maximum amount of hits required. (0 = disable)"})
        public int tier1baseDefense = 2;
        @Config.LangKey(value="configgui.grimoireofgaia.category.defense.Tier2baseDefense")
        @Config.Comment(value={"Maximum amount of hits required. (0 = disable)"})
        public int tier2baseDefense = 4;
        @Config.LangKey(value="configgui.grimoireofgaia.category.defense.Tier3baseDefense")
        @Config.Comment(value={"Maximum amount of hits required. (0 = disable)"})
        public int tier3baseDefense = 8;
    }

    public static class Damage {
        @Config.LangKey(value="configgui.grimoireofgaia.category.damage.Menu0.BaseDamage")
        @Config.Comment(value={"Melee attacks deal an additional 2.0 (1 heart) of damage"})
        public boolean baseDamage = true;
        @Config.LangKey(value="configgui.grimoireofgaia.category.damage.Menu2.ShieldsBlockPiercing")
        @Config.Comment(value={"Archers arrows deal an additional 1 (0.5 heart) of damage"})
        public boolean shieldsBlockPiercing = true;
        @Config.LangKey(value="configgui.grimoireofgaia.category.damage.Menu1.BaseDamageArchers")
        @Config.Comment(value={"Shields Block Piercing Damage"})
        public boolean baseDamageArchers = true;
    }

    public static class Attributes {
        @Config.LangKey(value="configgui.grimoireofgaia.category.attributes.Tier1maxHealth")
        @Config.Comment(value={"Health: 40 (20 Hearts). (50 = half, 200 = double)"})
        public int tier1maxHealth = 100;
        @Config.LangKey(value="configgui.grimoireofgaia.category.attributes.Tier1attackDamage")
        @Config.Comment(value={"Damage: 4 (2 Hearts). (50 = half, 200 = double)"})
        public int tier1attackDamage = 100;
        @Config.LangKey(value="configgui.grimoireofgaia.category.attributes.Tier2maxHealth")
        @Config.Comment(value={"Health: 80 (40 Hearts). (50 = half, 200 = double)"})
        public int tier2maxHealth = 100;
        @Config.LangKey(value="configgui.grimoireofgaia.category.attributes.Tier2attackDamage")
        @Config.Comment(value={"Damage: 6 (3 Hearts). (50 = half, 200 = double)"})
        public int tier2attackDamage = 100;
        @Config.LangKey(value="configgui.grimoireofgaia.category.attributes.Tier3maxHealth")
        @Config.Comment(value={"Health: 160 (80 Hearts). (50 = half, 200 = double)"})
        public int tier3maxHealth = 100;
        @Config.LangKey(value="configgui.grimoireofgaia.category.attributes.Tier3attackDamage")
        @Config.Comment(value={"Damage: 8 (4 Hearts). (50 = half, 200 = double)"})
        public int tier3attackDamage = 100;
    }

    public static class Spawn {
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu0.SpawnDaysPassed")
        @Config.Comment(value={"Mobs only spawn after a certain amount of days have passed"})
        public boolean spawnDaysPassed = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu1.SpawnDaysSet")
        @Config.Comment(value={"Amount of days required to have passed before they can start spawning"})
        public int spawnDaysSet = 3;
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu2.SpawnLevel3Rain")
        @Config.Comment(value={"Level 3 mobs only spawn when it is raining/snowing."})
        public boolean spawnLevel3Rain = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu5.AdditionalSpawnBlocks")
        @Config.Comment(value={"Additional Blocks Gaia mobs can spawn on"})
        public String[] additionalSpawnBlocks = new String[]{Blocks.field_150322_A.getRegistryName().toString()};
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu6.AdditionalFlowerSpawnBlocks")
        @Config.Comment(value={"Additional Blocks Gaia flower can spawn on"})
        public String[] additionalFlowerSpawnBlocks = new String[]{Blocks.field_150322_A.getRegistryName().toString()};
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu7.Weather")
        @Config.Comment(value={"Remove spawn conditions related to weather."})
        public boolean spawnWeather = false;
        @Config.LangKey(value="configgui.grimoireofgaia.category.spawn.Menu8.Height")
        @Config.Comment(value={"Remove spawn conditions related to height (Y-axis)."})
        public boolean disableYRestriction = false;
    }

    public static class General {
        @Config.LangKey(value="entity.grimoireofgaia.beholderl.name")
        @Config.Comment(value={"Beholder"})
        @Config.RequiresMcRestart
        public int spawnBeholder = 1;
        @Config.LangKey(value="entity.grimoireofgaia.ender_dragon_girl.name")
        @Config.Comment(value={"Ender Dragon Girl"})
        @Config.RequiresMcRestart
        public int spawnEnderDragonGirl = 1;
        @Config.LangKey(value="entity.grimoireofgaia.vase_nether.name")
        @Config.Comment(value={"Ancient Vase (Nether)"})
        @Config.RequiresMcRestart
        public int spawnVaseNether = 12;
        @Config.LangKey(value="entity.grimoireofgaia.succubus.name")
        @Config.Comment(value={"Succubus"})
        @Config.RequiresMcRestart
        public int spawnSuccubus = 16;
        @Config.LangKey(value="entity.grimoireofgaia.wither_cow.name")
        @Config.Comment(value={"Wither Cow"})
        @Config.RequiresMcRestart
        public int spawnWitherCow = 12;
        @Config.LangKey(value="entity.grimoireofgaia.baphomet.name")
        @Config.Comment(value={"Baphomet"})
        @Config.RequiresMcRestart
        public int spawnBaphomet = 12;
        @Config.LangKey(value="entity.grimoireofgaia.cecaelia.name")
        @Config.Comment(value={"Cecaelia"})
        @Config.RequiresMcRestart
        public int spawnCecaelia = 80;
        @Config.LangKey(value="entity.grimoireofgaia.mermaid.name")
        @Config.Comment(value={"Mermaid"})
        @Config.RequiresMcRestart
        public int spawnMermaid = 40;
        @Config.LangKey(value="entity.grimoireofgaia.sharko.name")
        @Config.Comment(value={"Sharko"})
        @Config.RequiresMcRestart
        public int spawnSharko = 40;
        @Config.LangKey(value="entity.grimoireofgaia.dwarf.name")
        @Config.Comment(value={"Dwarf"})
        @Config.RequiresMcRestart
        public int spawnDwarf = 30;
        @Config.LangKey(value="entity.grimoireofgaia.gryphon.name")
        @Config.Comment(value={"Gryphon"})
        @Config.RequiresMcRestart
        public int spawnGryphon = 60;
        @Config.LangKey(value="entity.grimoireofgaia.valkyrie.name")
        @Config.Comment(value={"Valkyrie"})
        @Config.RequiresMcRestart
        public int spawnValkyrie = 10;
        @Config.LangKey(value="entity.grimoireofgaia.dullahan.name")
        @Config.Comment(value={"Dullahan"})
        @Config.RequiresMcRestart
        public int spawnDullahan = 100;
        @Config.LangKey(value="entity.grimoireofgaia.banshee.name")
        @Config.Comment(value={"Banshee"})
        @Config.RequiresMcRestart
        public int spawnBanshee = 80;
        @Config.LangKey(value="entity.grimoireofgaia.selkie.name")
        @Config.Comment(value={"Selkie"})
        @Config.RequiresMcRestart
        public int spawnSelkie = 30;
        @Config.LangKey(value="entity.grimoireofgaia.kobold.name")
        @Config.Comment(value={"Kobold"})
        @Config.RequiresMcRestart
        public int spawnKobold = 60;
        @Config.LangKey(value="entity.grimoireofgaia.yeti.name")
        @Config.Comment(value={"Yeti"})
        @Config.RequiresMcRestart
        public int spawnYeti = 80;
        @Config.LangKey(value="entity.grimoireofgaia.hunter.name")
        @Config.Comment(value={"Hunter"})
        @Config.RequiresMcRestart
        public int spawnHunter = 60;
        @Config.LangKey(value="entity.grimoireofgaia.cobble_golem.name")
        @Config.Comment(value={"Cobble Golem"})
        @Config.RequiresMcRestart
        public int spawnCobbleGolem = 60;
        @Config.LangKey(value="entity.grimoireofgaia.shaman.name")
        @Config.Comment(value={"Shaman"})
        @Config.RequiresMcRestart
        public int spawnShaman = 60;
        @Config.LangKey(value="entity.grimoireofgaia.cobblestone_golem.name")
        @Config.Comment(value={"Cobblestone Golem"})
        @Config.RequiresMcRestart
        public int spawnCobblestoneGolem = 60;
        @Config.LangKey(value="entity.grimoireofgaia.siren.name")
        @Config.Comment(value={"Siren"})
        @Config.RequiresMcRestart
        public int spawnSiren = 60;
        @Config.LangKey(value="entity.grimoireofgaia.naga.name")
        @Config.Comment(value={"Naga"})
        @Config.RequiresMcRestart
        public int spawnNaga = 30;
        @Config.LangKey(value="entity.grimoireofgaia.sludge_girl.name")
        @Config.Comment(value={"Sludge Girl"})
        @Config.RequiresMcRestart
        public int spawnSludgeGirl = 100;
        @Config.LangKey(value="entity.grimoireofgaia.gelatinous_slime.name")
        @Config.Comment(value={"Gelatinous Slime"})
        @Config.RequiresMcRestart
        public int spawnGelatinousSlime = 80;
        @Config.LangKey(value="entity.grimoireofgaia.satyress.name")
        @Config.Comment(value={"Satyress"})
        @Config.RequiresMcRestart
        public int spawnSatyress = 20;
        @Config.LangKey(value="entity.grimoireofgaia.centaur.name")
        @Config.Comment(value={"Centaur"})
        @Config.RequiresMcRestart
        public int spawnCentaur = 20;
        @Config.LangKey(value="entity.grimoireofgaia.harpy.name")
        @Config.Comment(value={"Harpy"})
        @Config.RequiresMcRestart
        public int spawnHarpy = 100;
        @Config.LangKey(value="entity.grimoireofgaia.minotaurus.name")
        @Config.Comment(value={"Minotaurus"})
        @Config.RequiresMcRestart
        public int spawnMinotaurus = 80;
        @Config.LangKey(value="entity.grimoireofgaia.minotaur.name")
        @Config.Comment(value={"Minotaur"})
        @Config.RequiresMcRestart
        public int spawnMinotaur = 10;
        @Config.LangKey(value="entity.grimoireofgaia.goblin.name")
        @Config.Comment(value={"Goblin"})
        public int spawnGoblin = 30;
        @Config.LangKey(value="entity.grimoireofgaia.orc.name")
        @Config.Comment(value={"Orc"})
        public int spawnOrc = 80;
        @Config.LangKey(value="entity.grimoireofgaia.ant_hill.name")
        @Config.Comment(value={"Ant Hill"})
        @Config.RequiresMcRestart
        public int spawnAntHill = 20;
        @Config.LangKey(value="entity.grimoireofgaia.ant_ranger.name")
        @Config.Comment(value={"Ant Salvager"})
        @Config.RequiresMcRestart
        public int spawnAntRanger = 20;
        @Config.LangKey(value="entity.grimoireofgaia.mummy.name")
        @Config.Comment(value={"Mummy"})
        @Config.RequiresMcRestart
        public int spawnMummy = 100;
        @Config.LangKey(value="entity.grimoireofgaia.anubis.name")
        @Config.Comment(value={"Anubis"})
        @Config.RequiresMcRestart
        public int spawnAnubis = 80;
        @Config.LangKey(value="entity.grimoireofgaia.sphinx.name")
        @Config.Comment(value={"Sphinx"})
        @Config.RequiresMcRestart
        public int spawnSphinx = 10;
        @Config.LangKey(value="entity.grimoireofgaia.dryad.name")
        @Config.Comment(value={"Dryad"})
        @Config.RequiresMcRestart
        public int spawnDryad = 60;
        @Config.LangKey(value="entity.grimoireofgaia.bee.name")
        @Config.Comment(value={"Bee"})
        @Config.RequiresMcRestart
        public int spawnBee = 40;
        @Config.LangKey(value="entity.grimoireofgaia.mandragora.name")
        @Config.Comment(value={"Mandragora"})
        @Config.RequiresMcRestart
        public int spawnMandragora = 60;
        @Config.LangKey(value="entity.grimoireofgaia.werecat.name")
        @Config.Comment(value={"Werecat"})
        @Config.RequiresMcRestart
        public int spawnWerecat = 80;
        @Config.LangKey(value="entity.grimoireofgaia.spriggan.name")
        @Config.Comment(value={"Spriggan"})
        @Config.RequiresMcRestart
        public int spawnSpriggan = 40;
        @Config.LangKey(value="entity.grimoireofgaia.cyclops.name")
        @Config.Comment(value={"Cyclops"})
        @Config.RequiresMcRestart
        public int spawnCyclops = 40;
        @Config.LangKey(value="entity.grimoireofgaia.yuki-onna.name")
        @Config.Comment(value={"Yuki-Onna"})
        @Config.RequiresMcRestart
        public int spawnYukiOnna = 60;
        @Config.LangKey(value="entity.grimoireofgaia.oni.name")
        @Config.Comment(value={"Oni"})
        @Config.RequiresMcRestart
        public int spawnOni = 80;
        @Config.LangKey(value="entity.grimoireofgaia.nine_tails.name")
        @Config.Comment(value={"Nine Tails"})
        @Config.RequiresMcRestart
        public int spawnNineTails = 40;
        @Config.LangKey(value="entity.grimoireofgaia.kikimora.name")
        @Config.Comment(value={"Kikimora"})
        @Config.RequiresMcRestart
        public int spawnKikimora = 40;
        @Config.LangKey(value="entity.grimoireofgaia.dhampir.name")
        @Config.Comment(value={"Dhampir"})
        @Config.RequiresMcRestart
        public int spawnDhampir = 80;
        @Config.LangKey(value="entity.grimoireofgaia.vampire.name")
        @Config.Comment(value={"Vampire"})
        @Config.RequiresMcRestart
        public int spawnVampire = 10;
        @Config.LangKey(value="entity.grimoireofgaia.matango.name")
        @Config.Comment(value={"Matango"})
        @Config.RequiresMcRestart
        public int spawnMatango = 60;
        @Config.LangKey(value="entity.grimoireofgaia.toad.name")
        @Config.Comment(value={"Toad"})
        @Config.RequiresMcRestart
        public int spawnToad = 80;
        @Config.LangKey(value="entity.grimoireofgaia.harpy_wizard.name")
        @Config.Comment(value={"Wizard Harpy"})
        @Config.RequiresMcRestart
        public int spawnHarpyWizard = 60;
        @Config.LangKey(value="entity.grimoireofgaia.witch.name")
        @Config.Comment(value={"Witch"})
        @Config.RequiresMcRestart
        public int spawnWitch = 60;
        @Config.LangKey(value="entity.grimoireofgaia.vase.name")
        @Config.Comment(value={"Ancient Vase"})
        @Config.RequiresMcRestart
        public int spawnVase = 40;
        @Config.LangKey(value="entity.grimoireofgaia.creep.name")
        @Config.Comment(value={"Creep"})
        @Config.RequiresMcRestart
        public int spawnCreep = 80;
        @Config.LangKey(value="entity.grimoireofgaia.ender_eye.name")
        @Config.Comment(value={"Ender Eye"})
        @Config.RequiresMcRestart
        public int spawnEnderEye = 40;
        @Config.LangKey(value="entity.grimoireofgaia.arachne.name")
        @Config.Comment(value={"Arachne"})
        @Config.RequiresMcRestart
        public int spawnArachne = 80;
        @Config.LangKey(value="entity.grimoireofgaia.mimic.name")
        @Config.Comment(value={"Mimic"})
        @Config.RequiresMcRestart
        public int spawnMimic = 40;
        @Config.LangKey(value="entity.grimoireofgaia.deathword.name")
        @Config.Comment(value={"Deathword"})
        @Config.RequiresMcRestart
        public int spawnDeathword = 40;
        @Config.LangKey(value="entity.grimoireofgaia.bone_knight.name")
        @Config.Comment(value={"Bone Knight"})
        @Config.RequiresMcRestart
        public int spawnBoneKnight = 40;
        @Config.LangKey(value="entity.grimoireofgaia.flesh_lich.name")
        @Config.Comment(value={"Flesh Lich"})
        @Config.RequiresMcRestart
        public int spawnFleshLich = 40;
    }

    @Mod.EventBusSubscriber(modid="grimoireofgaia")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("grimoireofgaia")) {
                ConfigManager.sync((String)"grimoireofgaia", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

