/*
 * Decompiled with CFR 0.152.
 */
package gaia.block;

import gaia.block.BlockBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpawnGuard
extends BlockBase {
    private static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB DOWN_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.06f, 1.0);
    private static final AxisAlignedBB UP_BOX = new AxisAlignedBB(0.0, (double)0.94f, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.0, 0.0, (double)0.94f, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.06f);
    private static final AxisAlignedBB EAST_BOX = new AxisAlignedBB((double)0.94f, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.06f, 1.0, 1.0);

    public BlockSpawnGuard() {
        super(Material.field_151580_n, "spawn_guard");
        this.func_149713_g(0);
        this.func_149711_c(0.0f);
        this.func_149752_b(6.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.NORTH)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"text.grimoireofgaia.grimoireofgaia.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"block.grimoireofgaia.spawn_guard.desc", (Object[])new Object[]{8}));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        switch (type) {
            case UP_NORTH: 
            case UP_SOUTH: 
            case UP_WEST: 
            case UP_EAST: {
                return UP_BOX;
            }
            case VERTICAL_NORTH: {
                return NORTH_BOX;
            }
            case VERTICAL_SOUTH: {
                return SOUTH_BOX;
            }
            case VERTICAL_WEST: {
                return WEST_BOX;
            }
            case VERTICAL_EAST: {
                return EAST_BOX;
            }
        }
        return DOWN_BOX;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.getConstant(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getId();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.getFromFacings(facing.func_176740_k() != EnumFacing.Axis.Y ? facing.func_176734_d() : placer.func_174811_aO(), facing.func_176734_d())));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        NORTH(2, "north"),
        SOUTH(0, "south"),
        WEST(1, "west"),
        EAST(3, "east"),
        UP_NORTH(6, "u_north"),
        UP_SOUTH(4, "u_south"),
        UP_WEST(5, "u_west"),
        UP_EAST(7, "u_east"),
        VERTICAL_NORTH(10, "v_north"),
        VERTICAL_SOUTH(8, "v_south"),
        VERTICAL_WEST(9, "v_west"),
        VERTICAL_EAST(11, "v_east");

        private int id;
        private String name;

        private EnumType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType getFromFacings(EnumFacing horizontalFacing, EnumFacing verticalFacing) {
            int index = horizontalFacing.func_176736_b() + EnumType.getVerticalIncrement(verticalFacing);
            return EnumType.getConstant(index);
        }

        private static int getVerticalIncrement(EnumFacing verticalFacing) {
            if (verticalFacing == EnumFacing.DOWN) {
                return 0;
            }
            return verticalFacing == EnumFacing.UP ? 4 : 8;
        }

        public int getId() {
            return this.id;
        }

        public static EnumType getConstant(int meta) {
            if (0 > meta || meta > 11) {
                return NORTH;
            }
            return EnumType.values()[meta];
        }
    }
}

