/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import com.google.common.base.Predicate;
import gaia.GaiaConfig;
import gaia.entity.EntityMobAssist;
import gaia.init.GaiaItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMobAssistBase
extends EntityMobAssist
implements IRangedAttackMob {
    private static final DataParameter<Boolean> FRIENDLY = EntityDataManager.func_187226_a(EntityMobAssistBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAINearestAttackableTarget<EntityPlayer> aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private EntityAINearestAttackableTarget aiNearestAttackableHostileTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, (Predicate)new Predicate<EntityLiving>(){

        public boolean apply(@Nullable EntityLiving p_apply_1_) {
            return p_apply_1_ != null && IMob.field_175450_e.apply((Object)p_apply_1_) && !(p_apply_1_ instanceof EntityCreeper);
        }
    });

    public EntityMobAssistBase(World worldIn) {
        super(worldIn);
        if (GaiaConfig.OPTIONS.passiveHostileAllMobs) {
            this.field_70715_bh.func_75776_a(2, this.aiNearestAttackableTarget);
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    public double func_70033_W() {
        return -0.6;
    }

    public boolean isTameable() {
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == GaiaItems.FOOD_MONSTER_FEED && !this.isFriendly() && this.isTameable()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.field_70180_af.func_187227_b(FRIENDLY, (Object)true);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiNearestAttackableHostileTarget);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (EntityMobAssistBase.class.isAssignableFrom(cls)) {
            return false;
        }
        return cls == EntityCreeper.class ? false : super.func_70686_a(cls);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FRIENDLY, (Object)false);
    }

    public boolean isFriendly() {
        return (Boolean)this.field_70180_af.func_187225_a(FRIENDLY);
    }

    public void setFriendly() {
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiNearestAttackableHostileTarget);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("friendly", this.isFriendly());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(FRIENDLY, (Object)compound.func_74767_n("friendly"));
        if (compound.func_74767_n("friendly")) {
            this.setFriendly();
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (GaiaConfig.DAMAGE.baseDamage) {
                if (entity instanceof EntityPlayer && GaiaConfig.DAMAGE.shieldsBlockPiercing) {
                    ItemStack itemstack;
                    EntityPlayer player = (EntityPlayer)entity;
                    ItemStack itemStack = itemstack = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
                    if (itemstack.func_77973_b() == Items.field_185159_cQ) {
                        return true;
                    }
                }
                if (!this.isFriendly()) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76433_i, 2, 0));
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else if (id == 8) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (id == 9) {
            this.spawnParticles(EnumParticleTypes.FLAME);
        } else if (id == 10) {
            this.spawnParticles(EnumParticleTypes.SPELL_WITCH);
        } else if (id == 11) {
            this.spawnParticles(EnumParticleTypes.SMOKE_NORMAL);
        } else if (id == 12) {
            this.spawnParticles(EnumParticleTypes.EXPLOSION_NORMAL);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + this.field_70146_Z.nextDouble() * (double)this.field_70130_N * 2.0 - (double)this.field_70130_N, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() * (double)this.field_70130_N * 2.0 - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void beaconDebuff(double range, Potion effect, int duration, int amplifier) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(range);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (mob instanceof EntityMob || !(mob instanceof IMob) && !(mob instanceof EntityPlayer)) continue;
                mob.func_70690_d(new PotionEffect(effect, duration, amplifier, true, true));
            }
        }
    }

    protected void spawnLingeringCloud(EntityLivingBase sourceMob, Potion potionIn, int durationIn, int amplifierIn) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(sourceMob.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityareaeffectcloud.func_184481_a(sourceMob);
        entityareaeffectcloud.func_184483_a(2.5f);
        entityareaeffectcloud.func_184495_b(-0.5f);
        entityareaeffectcloud.func_184485_d(10);
        entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
        entityareaeffectcloud.func_184496_a(new PotionEffect(potionIn, durationIn, amplifierIn));
        this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
    }

    public void knockBack(double xRatio, double zRatio, double power) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float f1 = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            float f2 = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70181_x /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= xRatio / (double)f1 * (double)f2;
            this.field_70181_x += (double)f2;
            this.field_70179_y -= zRatio / (double)f1 * (double)f2;
            if (this.field_70181_x > power) {
                this.field_70181_x = power;
            }
        }
    }

    public boolean daysPassed() {
        int daysPassedClientInt = (int)(this.field_70170_p.func_72820_D() / 24000L);
        return GaiaConfig.SPAWN.spawnDaysSet <= daysPassedClientInt;
    }

    @Override
    public boolean func_70601_bi() {
        if (GaiaConfig.SPAWN.spawnDaysPassed) {
            return this.daysPassed() && super.func_70601_bi();
        }
        return super.func_70601_bi();
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        if (!GaiaConfig.OPTIONS.disableDrops) {
            this.func_70628_a(wasRecentlyHit, lootingModifier);
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return false;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }
}

