/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.Ranged;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityGaiaArachne
extends EntityMobHostileBase
implements IRangedAttackMob {
    private EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.25, true);
    private int switchHealth;
    private int spawn;
    private int spawnTimer;
    private boolean animationPlay;
    private int animationTimer;
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityGaiaArachne.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityGaiaArachne(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 1.6f);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
        this.spawn = 0;
        this.spawnTimer = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float yRatio, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        Ranged.web(target, (EntityLivingBase)this, distanceFactor, 0.0);
        this.setEquipment((byte)1);
        this.animationPlay = true;
        this.animationTimer = 0;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaArachne.class;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                boolean byte1 = false;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        this.beaconMonster();
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.5f && this.switchHealth == 0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_DAGGER_METAL));
            this.setAI((byte)1);
            this.switchHealth = 1;
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.5f && this.switchHealth == 1) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP, 1, 0));
            this.setAI((byte)0);
            this.switchHealth = 0;
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.75f && this.func_110143_aJ() > 0.0f && this.spawn == 0) {
            this.setEquipment((byte)2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                this.setEquipment((byte)0);
                if (!this.field_70170_p.field_72995_K) {
                    this.setSpawn((byte)0);
                }
                this.spawnTimer = 0;
                this.spawn = 1;
            }
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.25f && this.func_110143_aJ() > 0.0f && this.spawn == 1) {
            this.setEquipment((byte)2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                this.setEquipment((byte)0);
                if (!this.field_70170_p.field_72995_K) {
                    this.setSpawn((byte)0);
                }
                this.spawnTimer = 0;
                this.spawn = 2;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setEquipment((byte)0);
                this.animationPlay = false;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiArrowAttack);
            this.setEquipment((byte)0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151032_g));
        }
        if (id == 2) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151055_y));
        }
    }

    private void setSpawn(byte id) {
        BlockPos blockpos = new BlockPos((Entity)this).func_177982_a(-1 + this.field_70146_Z.nextInt(3), 1, -1 + this.field_70146_Z.nextInt(3));
        if (id == 0) {
            EntityCaveSpider entitySpawn = new EntityCaveSpider(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
    }

    private void setCombatTask() {
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_PROP) {
            this.setAI((byte)0);
        } else {
            this.setAI((byte)1);
        }
    }

    private void beaconMonster() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(6.0);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (!(mob instanceof EntitySpider)) continue;
                mob.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 1, true, true));
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected PathNavigate getNewNavigator(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    private boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    private void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.ARACHNE_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.ARACHNE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.ARACHNE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.field_70146_Z.nextInt(2)) {
            case 0: {
                return GaiaLootTables.ENTITIES_GAIA_ARACHNE;
            }
            case 1: {
                return LootTableList.field_186432_n;
            }
        }
        return GaiaLootTables.ENTITIES_GAIA_ARACHNE;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(4) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.MISC_FURNACE_FUEL, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_70099_a(new ItemStack(GaiaItems.BOX, 1, 0), 0.0f);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.MISC_BOOK, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        ItemStack weaponCustom = new ItemStack(GaiaItems.WEAPON_PROP, 1, 0);
        weaponCustom.func_77966_a(Enchantments.field_180313_o, 2);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, weaponCustom);
        this.setCombatTask();
        return ret;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public void func_70110_aj() {
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < (!GaiaConfig.SPAWN.disableYRestriction ? 32.0 : 512.0) && super.func_70601_bi();
    }
}

