/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobAssistDay;
import gaia.entity.ai.EntityAIGaiaAttackRangedBow;
import gaia.entity.ai.EntityAIGaiaValidateTargetPlayer;
import gaia.entity.ai.GaiaIRangedAttackMob;
import gaia.entity.ai.Ranged;
import gaia.entity.monster.EntityGaiaHorse;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaCentaur
extends EntityMobAssistDay
implements GaiaIRangedAttackMob {
    private static final String MOB_TYPE_TAG = "MobType";
    private static final DataParameter<Boolean> MALE = EntityDataManager.func_187226_a(EntityGaiaCentaur.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaCentaur.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityAIGaiaAttackRangedBow aiArrowAttack = new EntityAIGaiaAttackRangedBow(this, 1.25, 20, 15.0);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee(this, 1.25, true){

        public void func_75251_c() {
            super.func_75251_c();
            EntityGaiaCentaur.this.func_184724_a(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityGaiaCentaur.this.func_184724_a(true);
        }
    };
    private EntityAIAvoidEntity<EntityPlayer> aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 4.0f, 1.25, 1.3);
    private EntityAIAvoidEntity<EntityCreature> aiAvoidCreature = new EntityAIAvoidEntity((EntityCreature)this, EntityCreature.class, 4.0f, 1.25, 1.3);
    private EntityAIAvoidEntity<EntityMob> aiAvoidMob = new EntityAIAvoidEntity((EntityCreature)this, EntityMob.class, 4.0f, 1.25, 1.3);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGaiaCentaur.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ItemStack TIPPED_ARROW_CUSTOM = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185246_r);
    private static final ItemStack TIPPED_ARROW_CUSTOM_2 = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185226_I);
    private int fullHealth;
    private int regenerateHealth;
    private boolean isFriendly;

    public EntityGaiaCentaur(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.fullHealth = 0;
        this.regenerateHealth = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIGaiaValidateTargetPlayer(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public double func_70033_W() {
        return -0.3;
    }

    @Override
    public boolean isTameable() {
        return true;
    }

    public boolean func_175446_cd() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.isFriendly() && !this.isFriendly) {
            this.setAI((byte)2);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_SWORD_WOOD));
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
            this.isFriendly = true;
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.25f && this.fullHealth == 0) {
            ItemStack stacky = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, 0), (PotionType)PotionTypes.field_185220_C);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stacky);
            this.setAI((byte)1);
            this.setEquipment((byte)1);
            this.fullHealth = 1;
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 && this.fullHealth == 1) {
            if (this.regenerateHealth <= 100) {
                ++this.regenerateHealth;
            } else {
                this.func_184185_a(SoundEvents.field_187664_bz, 0.15f, 1.0f);
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 360, 3));
                this.regenerateHealth = 0;
            }
        } else if (this.func_110143_aJ() >= EntityAttributes.MAX_HEALTH_1 && this.fullHealth == 1) {
            if (!this.isFriendly()) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                this.setAI((byte)0);
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_SWORD_WOOD));
                this.setAI((byte)2);
            }
            this.func_184589_d(MobEffects.field_76428_l);
            this.setEquipment((byte)0);
            this.fullHealth = 0;
            this.regenerateHealth = 0;
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0 && !this.isFriendly()) {
            this.field_70714_bg.func_85156_a(this.aiAvoid);
            this.field_70714_bg.func_85156_a(this.aiAvoidCreature);
            this.field_70714_bg.func_85156_a(this.aiAvoidMob);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(1, this.aiAvoid);
            this.field_70714_bg.func_75776_a(1, this.aiAvoidCreature);
            this.field_70714_bg.func_75776_a(1, this.aiAvoidMob);
        }
        if (id == 2) {
            this.field_70714_bg.func_85156_a(this.aiAvoid);
            this.field_70714_bg.func_85156_a(this.aiAvoidCreature);
            this.field_70714_bg.func_85156_a(this.aiAvoidMob);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151110_aK));
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151008_G));
        }
    }

    private void setBodyType(String id) {
        if (id == "none") {
            this.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
        }
        if (id == "male") {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151055_y));
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == Items.field_151031_f) {
            int i = 20;
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                i = 40;
            }
            this.aiArrowAttack.setAttackCooldown(i);
            this.setAI((byte)0);
        } else {
            this.setAI((byte)2);
        }
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaCentaur.class;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!target.field_70128_L) {
            Ranged.rangedAttack(target, (EntityLivingBase)this, distanceFactor);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(MALE, (Object)false);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    protected SoundEvent func_184639_G() {
        return !this.isMale() ? GaiaSounds.CENTAUR_SAY : GaiaSounds.CENTAUR_MALE_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return !this.isMale() ? GaiaSounds.CENTAUR_HURT : GaiaSounds.CENTAUR_MALE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return !this.isMale() ? GaiaSounds.CENTAUR_DEATH : GaiaSounds.CENTAUR_MALE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_CENTAUR;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(Items.field_151116_aA, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.BAG_ARROW, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingData);
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.field_70180_af.func_187227_b(MALE, (Object)true);
            this.setBodyType("male");
            this.setTextureType(2);
        }
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f) {
                if (this.isMale()) {
                    this.setTextureType(3);
                } else {
                    this.setTextureType(1);
                }
            }
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        this.func_180483_b(difficulty);
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM);
            } else {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM_2);
            }
        }
        this.setCombatTask();
        if (this.field_70170_p.field_73012_v.nextInt(10000) == 0 && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            AbstractHorse abstracthorse = this.createHorse(difficulty);
            this.func_184220_m((Entity)abstracthorse);
        }
        return ret;
    }

    private AbstractHorse createHorse(DifficultyInstance difficulty) {
        EntityGaiaHorse entityHorse = new EntityGaiaHorse(this.field_70170_p);
        entityHorse.func_180482_a(difficulty, null);
        entityHorse.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityHorse.func_110234_j(true);
        entityHorse.func_70873_a(0);
        this.field_70170_p.func_72838_d((Entity)entityHorse);
        return entityHorse;
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(MALE);
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.field_70180_af.func_187227_b(MALE, (Object)compound.func_74767_n("male"));
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getTextureType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte b0 = compound.func_74771_c(MOB_TYPE_TAG);
            compound.func_74757_a("male", this.isMale());
            this.setTextureType(b0);
        }
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

