/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.EntityAIGaiaStrafe;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityGaiaDeathword
extends EntityMobHostileBase {
    private static final int DETECTION_RANGE = 6;
    private EntityAIAttackMelee aiMeleeAttack = new EntityAIAttackMelee((EntityCreature)this, 1.25, true);
    private EntityAIGaiaStrafe aiStrafe = new EntityAIGaiaStrafe((EntityLiving)this, 1.25, 20, 15.0);
    private boolean canSpawn;
    private int spawnTimer;
    private int spawnLimit;

    public EntityGaiaDeathword(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.canSpawn = true;
        this.spawnTimer = 0;
        this.spawnLimit = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_188424_y, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        this.beaconMonster();
        if (this.playerDetection(6)) {
            if (this.spawnLimit <= 3 && this.canSpawn) {
                if (this.spawnTimer != 60) {
                    ++this.spawnTimer;
                }
                if (this.spawnTimer == 60) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                    if (!this.field_70170_p.field_72995_K) {
                        switch (this.field_70146_Z.nextInt(4)) {
                            case 0: {
                                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                                if (!flag) {
                                    this.setSpawn((byte)0);
                                    break;
                                }
                                this.setSpawn((byte)1);
                                break;
                            }
                            case 1: {
                                this.setSpawn((byte)1);
                                break;
                            }
                            case 2: {
                                this.setSpawn((byte)2);
                                break;
                            }
                            case 3: {
                                this.setSpawn((byte)3);
                                break;
                            }
                        }
                    }
                    this.spawnTimer = 0;
                    ++this.spawnLimit;
                }
            }
            if (this.spawnLimit >= 4 && this.canSpawn) {
                this.setAI((byte)1);
                this.canSpawn = false;
            }
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (this.field_70159_w > 0.0 || this.field_70181_x > 0.0 || this.field_70179_y > 0.0) {
            for (int var5 = 0; var5 < 2; ++var5) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.func_70027_ad()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiStrafe);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiStrafe);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMeleeAttack);
        }
    }

    private void setSpawn(byte id) {
        EntityCreeper entitySpawn;
        BlockPos blockpos = new BlockPos((Entity)this).func_177982_a(-1 + this.field_70146_Z.nextInt(3), 1, -1 + this.field_70146_Z.nextInt(3));
        if (id == 0) {
            entitySpawn = new EntityCreeper(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
        if (id == 1) {
            entitySpawn = new EntitySkeleton(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            entitySpawn.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(GaiaItems.ACCESSORY_HEADGEAR, 1, 0));
            entitySpawn.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
        if (id == 2) {
            entitySpawn = new EntitySpider(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
        if (id == 3) {
            entitySpawn = new EntityZombie(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            entitySpawn.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(GaiaItems.ACCESSORY_HEADGEAR, 1, 0));
            entitySpawn.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiStrafe);
        this.setAI((byte)1);
    }

    private void beaconMonster() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(6.0);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (mob instanceof EntityPlayer) continue;
                mob.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 1, true, true));
            }
        }
    }

    private boolean playerDetection(int range) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g((double)range);
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        return !list.isEmpty();
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.BOOK_HIT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.BOOK_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.BOOK_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_DEATHWORD;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(Items.field_151121_aF, 1);
            }
            if (this.field_70146_Z.nextInt(4) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(Items.field_151122_aG, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_70099_a(new ItemStack(GaiaItems.BOX, 1, 0), 0.0f);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.BAG_BOOK, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.WEAPON_BOOK, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        ItemStack weaponCustom = new ItemStack(GaiaItems.WEAPON_PROP_ENCHANTED, 1);
        weaponCustom.func_77966_a(Enchantments.field_180313_o, 1);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, weaponCustom);
        this.setCombatTask();
        return ret;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < (!GaiaConfig.SPAWN.disableYRestriction ? 16.0 : 512.0) && super.func_70601_bi();
    }
}

