/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityGaiaGelatinousSlime
extends EntityMobHostileBase {
    private boolean animationPlay;
    private int animationTimer;
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;

    public EntityGaiaGelatinousSlime(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.75f, 1.75f);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.animationPlay = false;
        this.animationTimer = 0;
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.15, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.125);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76364_f();
        if (entity instanceof EntityArrow) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            this.func_70691_i(EntityAttributes.MAX_HEALTH_2 * 0.1f);
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70173_aa % 60 == 0) {
            this.animationPlay = true;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            this.squishAmount = -0.1f;
            if (this.animationTimer != 10) {
                ++this.animationTimer;
            } else {
                this.squishAmount = 1.0f;
                this.animationPlay = false;
            }
        }
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        this.beaconDebuff(4.0, MobEffects.field_76421_d, 100, 1);
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_2 && this.hasItem()) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            this.func_70691_i(EntityAttributes.MAX_HEALTH_2 * 0.2f);
        }
        super.func_70636_d();
    }

    private boolean hasItem() {
        return !this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b();
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnLingeringCloud((EntityLivingBase)this, MobEffects.field_76436_u, 200, 0);
        }
        super.func_70645_a(cause);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.field_70146_Z.nextInt(2)) {
            case 0: {
                return GaiaLootTables.ENTITIES_GAIA_GELATINOUS_SLIME;
            }
            case 1: {
                return LootTableList.field_186385_aj;
            }
        }
        return GaiaLootTables.ENTITIES_GAIA_GELATINOUS_SLIME;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(Items.field_151123_aH, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BOX_GOLD, 1);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.SPAWN_SLIME_GIRL, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.DOLL_SLIME_GIRL), 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        ItemStack offhand = ItemStack.field_190927_a;
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                offhand = new ItemStack((Item)Items.field_151031_f);
                break;
            }
            case 1: {
                offhand = new ItemStack(Items.field_151032_g);
                break;
            }
            case 2: {
                offhand = new ItemStack(Items.field_151052_q);
            }
        }
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, offhand);
        return ret;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

