/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.EntityAIGaiaAttackRangedBow;
import gaia.entity.ai.GaiaIRangedAttackMob;
import gaia.entity.ai.Ranged;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaGoblinFeral
extends EntityMobHostileBase
implements GaiaIRangedAttackMob {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private float explosionPower = 1.0f;
    private static final String MOB_TYPE_TAG = "MobType";
    private EntityAIGaiaAttackRangedBow aiArrowAttack = new EntityAIGaiaAttackRangedBow(this, 1.25, 20, 15.0);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.25, true){

        public void func_75251_c() {
            super.func_75251_c();
            EntityGaiaGoblinFeral.this.func_184724_a(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityGaiaGoblinFeral.this.func_184724_a(true);
        }
    };
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaGoblinFeral.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGaiaGoblinFeral.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityGaiaGoblinFeral.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ItemStack TIPPED_ARROW_CUSTOM = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185246_r);

    public EntityGaiaGoblinFeral(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.func_98053_h(true);
        if (!worldIn.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1 * 0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1 * 0.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.hasShield()) {
            Entity entity = source.func_76364_f();
            return !(entity instanceof EntityArrow) && super.func_70097_a(source, Math.min(amount, EntityAttributes.BASE_DEFENSE_1));
        }
        return super.func_70097_a(source, amount);
    }

    private boolean hasShield() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        return itemstack.func_77973_b() == Items.field_185159_cQ || itemstack.func_77973_b() == GaiaItems.SHIELD_PROP;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (this.getMobType() == 2 && entityIn instanceof EntityLivingBase) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
                this.ignite();
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn.func_188454_b() == 0) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == Items.field_151031_f) {
            int i = 20;
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                i = 40;
            }
            this.aiArrowAttack.setAttackCooldown(i);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    private int getMobType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setMobType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getMobType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte b0 = compound.func_74771_c(MOB_TYPE_TAG);
            this.setMobType(b0);
        }
        this.setCombatTask();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)Boolean.FALSE);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaGoblinFeral.class;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!target.field_70128_L) {
            Ranged.rangedAttack(target, (EntityLivingBase)this, distanceFactor);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public void func_70071_h_() {
        if (this.hasIgnited() && this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int i = 1;
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    private boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    private void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * this.explosionPower, false);
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float partialTickTime) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * partialTickTime) / (float)(this.fuseTime - 2);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.GOBLIN_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.GOBLIN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.GOBLIN_DEATH;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.getMobType() == 2) {
            this.explode();
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getMobType()) {
            case 0: {
                return GaiaLootTables.ENTITIES_GAIA_GOBLIN_FERAL_MELEE;
            }
            case 1: {
                return GaiaLootTables.ENTITIES_GAIA_GOBLIN_FERAL_RANGED;
            }
            case 2: {
                return GaiaLootTables.ENTITIES_GAIA_GOBLIN_FERAL_BOMBER;
            }
        }
        return LootTableList.field_186419_a;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit && this.field_70146_Z.nextInt(40) == 0) {
            this.func_145779_a(Items.field_191525_da, 1);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
            this.func_180483_b(difficulty);
            this.setTextureType(1);
        } else if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.setMobType(2);
            this.setTextureType(2);
        } else {
            this.func_180481_a(difficulty);
            this.setMobType(0);
            this.setTextureType(0);
        }
        this.setCombatTask();
        return ret;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_SWORD_WOOD));
            this.func_180483_b(difficulty);
        } else {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_AXE_WOOD));
            this.func_180483_b(difficulty);
        }
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

