/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileDay;
import gaia.entity.ai.EntityAIGaiaAttackRangedBow;
import gaia.entity.ai.GaiaIRangedAttackMob;
import gaia.entity.ai.Ranged;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaGorgon
extends EntityMobHostileDay
implements GaiaIRangedAttackMob {
    private static final int DETECTION_RANGE = 3;
    private static final int DETECTION_RANGE_STARE = 8;
    private static boolean isStaringRange;
    private boolean debugMode;
    private EntityAIGaiaAttackRangedBow aiArrowAttack = new EntityAIGaiaAttackRangedBow(this, 1.3, 20, 15.0);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.3, true){

        public void func_75251_c() {
            super.func_75251_c();
            EntityGaiaGorgon.this.func_184724_a(false);
            isStaringRange = false;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityGaiaGorgon.this.func_184724_a(true);
        }
    };
    private static final DataParameter<Boolean> SWINGING_ARMS;
    private static final ItemStack TIPPED_ARROW_CUSTOM;
    private static final ItemStack TIPPED_ARROW_CUSTOM_2;
    private int timer;
    private int switchDetect;
    private int switchEquip;
    private byte inWaterTimer;

    public EntityGaiaGorgon(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 6.0f;
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.WATER, 8.0f);
        this.timer = 0;
        this.switchDetect = 0;
        this.switchEquip = 0;
        this.inWaterTimer = 0;
        this.debugMode = false;
    }

    protected int func_190531_bD() {
        return 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIFindPlayer(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_3);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isArmored()) {
            return !(source instanceof EntityDamageSourceIndirect) && super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_3));
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_3));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.2);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, byte0 * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70026_G()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                this.func_70691_i(EntityAttributes.MAX_HEALTH_3 * 0.1f);
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.playerDetection(3)) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.playerDetection(8)) {
            if (!isStaringRange) {
                isStaringRange = true;
            }
        } else if (isStaringRange) {
            isStaringRange = false;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (!this.func_70644_a(MobEffects.field_76424_c)) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200, 0));
                }
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_DAGGER_METAL));
                this.setAI((byte)1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (this.func_70644_a(MobEffects.field_76424_c)) {
                    this.func_184589_d(MobEffects.field_76424_c);
                }
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                this.setAI((byte)0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        super.func_70636_d();
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == Items.field_151031_f) {
            int i = 20;
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                i = 40;
            }
            this.aiArrowAttack.setAttackCooldown(i);
            this.setAI((byte)0);
        } else {
            this.setAI((byte)1);
        }
    }

    private boolean playerDetection(int range) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g((double)range);
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        return !list.isEmpty();
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaGorgon.class;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!target.field_70128_L) {
            Ranged.rangedAttack(target, (EntityLivingBase)this, distanceFactor);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.GORGON_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.GORGON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.GORGON_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_GORGON;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(4) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FOOD_SMALL_APPLE_GOLD, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                ItemShard.dropNugget((Entity)this, 2);
            }
            int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNuggetAlt; ++i) {
                ItemShard.dropNugget((Entity)this, 3);
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_DIAMOND, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.BAG_ARROW, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.BUST_GORGON), 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.func_96094_a("WIP");
        if (!this.debugMode) {
            System.out.println("Disabled.");
            this.func_70106_y();
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        this.func_180483_b(difficulty);
        ItemStack bootsSwimming = new ItemStack((Item)Items.field_151021_T);
        this.func_184201_a(EntityEquipmentSlot.FEET, bootsSwimming);
        bootsSwimming.func_77966_a(Enchantments.field_185300_i, 2);
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM);
            } else {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM_2);
            }
        }
        this.setCombatTask();
        return ret;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }

    static {
        SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGaiaGorgon.class, (DataSerializer)DataSerializers.field_187198_h);
        TIPPED_ARROW_CUSTOM = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185246_r);
        TIPPED_ARROW_CUSTOM_2 = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185226_I);
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityGaiaGorgon targetLooked;
        private EntityPlayer player;
        private int stareTime;

        public AIFindPlayer(EntityGaiaGorgon p_i45842_1_) {
            super((EntityCreature)p_i45842_1_, EntityPlayer.class, false);
            this.targetLooked = p_i45842_1_;
        }

        public boolean func_75250_a() {
            double d0 = this.func_111175_f();
            this.player = this.targetLooked.field_70170_p.func_184150_a(this.targetLooked.field_70165_t, this.targetLooked.field_70163_u, this.targetLooked.field_70161_v, d0, d0, (Function)null, (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer p_apply_1_) {
                    return p_apply_1_ != null && targetLooked.shouldAttackPlayer(p_apply_1_);
                }
            });
            return this.player != null;
        }

        public void func_75249_e() {
            if (isStaringRange) {
                ++this.stareTime;
                if (this.stareTime >= 20) {
                    this.player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 5));
                    this.stareTime = 0;
                }
            }
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }
    }
}

