/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobAssistBase;
import gaia.entity.ai.EntityAIGaiaValidateTargetPlayer;
import gaia.entity.ai.Ranged;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import gaia.items.ItemWeaponBook;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityGaiaHarpyWizard
extends EntityMobAssistBase
implements IRangedAttackMob {
    private EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private EntityAIAvoidEntity<EntityPlayer> aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 20.0f, 1.25, 1.3);
    private boolean animationPlay;
    private int animationTimer;
    private int switchHealth;

    public EntityGaiaHarpyWizard(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
        this.animationPlay = false;
        this.animationTimer = 0;
        this.switchHealth = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIGaiaValidateTargetPlayer(this));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_FREEZING) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 0);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_NIGHTMARE) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 1);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_METAL) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 2);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_ENDER) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 3);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_HUNGER) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 4);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_BATTLE) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 5);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_NATURE) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 6);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK_WITHER) {
            Ranged.magicRandom(target, (EntityLivingBase)this, distanceFactor, 0.0, 7);
        }
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_BOOK) {
            Ranged.magic(target, (EntityLivingBase)this, distanceFactor);
        }
        this.setEquipment((byte)1);
        this.animationPlay = true;
        this.animationTimer = 0;
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaHarpyWizard.class;
    }

    public boolean func_175446_cd() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.25f && this.switchHealth == 0) {
            switch (this.field_70146_Z.nextInt(2)) {
                case 0: {
                    this.setAI((byte)1);
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    this.setEquipment((byte)2);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.25f && this.switchHealth == 1) {
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
            this.setAI((byte)0);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, itemstack);
            this.setEquipment((byte)0);
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setEquipment((byte)0);
                this.animationPlay = false;
            }
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a(this.aiAvoid);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiArrowAttack);
            this.setEquipment((byte)0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(2, this.aiAvoid);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151055_y));
        }
        if (id == 2) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151008_G));
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        this.field_70714_bg.func_85156_a(this.aiAvoid);
        ItemStack itemstack = this.func_184592_cb();
        if (itemstack.func_77973_b() instanceof ItemWeaponBook) {
            this.setAI((byte)0);
        } else {
            this.setAI((byte)1);
        }
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.HARPY_WIZARD_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.HARPY_WIZARD_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return GaiaSounds.HARPY_WIZARD_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_HARPY_WIZARD;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(GaiaItems.MISC_SOUL_FIRE, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.MISC_BOOK, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        switch (this.field_70170_p.field_73012_v.nextInt(3)) {
            case 0: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_FREEZING));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_FREEZING));
                break;
            }
            case 1: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_NIGHTMARE));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_NIGHTMARE));
                break;
            }
            case 2: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_METAL));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_METAL));
                break;
            }
            case 3: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_ENDER));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_ENDER));
                break;
            }
            case 4: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_HUNGER));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_HUNGER));
                break;
            }
            case 5: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_BATTLE));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_BATTLE));
                break;
            }
            case 6: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_NATURE));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_NATURE));
                break;
            }
            case 7: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK_WITHER));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(GaiaItems.WEAPON_BOOK_WITHER));
                break;
            }
            default: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_BOOK));
            }
        }
        this.func_180483_b(difficulty);
        this.setCombatTask();
        return ret;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

