/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileDay;
import gaia.entity.ai.EntityAIGaiaAttackRangedBow;
import gaia.entity.ai.GaiaIRangedAttackMob;
import gaia.entity.ai.Ranged;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaSelkie
extends EntityMobHostileDay
implements GaiaIRangedAttackMob {
    private static final int DETECTION_RANGE = 3;
    private EntityAIGaiaAttackRangedBow aiArrowAttack = new EntityAIGaiaAttackRangedBow(this, 1.25, 20, 15.0);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.25, true){

        public void func_75251_c() {
            super.func_75251_c();
            EntityGaiaSelkie.this.func_184724_a(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityGaiaSelkie.this.func_184724_a(true);
        }
    };
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGaiaSelkie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ItemStack TIPPED_ARROW_CUSTOM = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185246_r);
    private static final ItemStack TIPPED_ARROW_CUSTOM_2 = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185226_I);
    private int timer;
    private int switchDetect;
    private int switchEquip;

    public EntityGaiaSelkie(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.timer = 0;
        this.switchDetect = 0;
        this.switchEquip = 0;
    }

    protected int func_190531_bD() {
        return 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 30, 1));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (this.playerDetection(3)) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (!this.func_70644_a(MobEffects.field_76424_c)) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200, 0));
                }
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_DAGGER_METAL));
                this.setAI((byte)1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (this.func_70644_a(MobEffects.field_76424_c)) {
                    this.func_184589_d(MobEffects.field_76424_c);
                }
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                this.setAI((byte)0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
                this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
            }
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == Items.field_151031_f) {
            int i = 20;
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                i = 40;
            }
            this.aiArrowAttack.setAttackCooldown(i);
            this.setAI((byte)0);
        } else {
            this.setAI((byte)1);
        }
    }

    private boolean playerDetection(int range) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g((double)range);
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        return !list.isEmpty();
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaSelkie.class;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!target.field_70128_L) {
            Ranged.rangedAttack(target, (EntityLivingBase)this, distanceFactor);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.SELKIE_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.SELKIE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.SELKIE_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_SELKIE;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.MISC_FUR, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.BAG_ARROW, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                ItemStack enchantmentBook = new ItemStack(Items.field_151134_bR);
                ItemEnchantedBook.func_92115_a((ItemStack)enchantmentBook, (EnchantmentData)new EnchantmentData(Enchantments.field_151369_A, 1));
                this.func_70099_a(enchantmentBook, 1.0f);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        this.func_180483_b(difficulty);
        ItemStack bootsSwimming = new ItemStack((Item)Items.field_151021_T);
        this.func_184201_a(EntityEquipmentSlot.FEET, bootsSwimming);
        bootsSwimming.func_77966_a(Enchantments.field_185300_i, 2);
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM);
            } else {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM_2);
            }
        }
        this.setCombatTask();
        return ret;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

