/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobAssistDay;
import gaia.entity.ai.EntityAIGaiaValidateTargetPlayer;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaValkyrie
extends EntityMobAssistDay {
    private static final double DETECTION_RANGE = 6.0;
    private static final DataParameter<Boolean> ANNOYED = EntityDataManager.func_187226_a(EntityGaiaValkyrie.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.3, true);
    private EntityAINearestAttackableTarget<EntityPlayer> aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private int aggression;
    private int aggressive;
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;

    public EntityGaiaValkyrie(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 2.0f);
        this.field_70728_aV = 40;
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
        this.aggression = 0;
        this.aggressive = 0;
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIGaiaValidateTargetPlayer(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_3);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isArmored()) {
            return !(source instanceof EntityDamageSourceIndirect) && super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_3));
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_3));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.2);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                int byte1 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 20;
                    byte1 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 30;
                    byte1 = 20;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 0));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, byte1 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (!this.isAnnoyed()) {
            if (this.aggressive <= 4) {
                if (this.playerDetection(6.0)) {
                    if (this.aggression <= 60) {
                        ++this.aggression;
                    } else {
                        this.aggression = 0;
                        ++this.aggressive;
                    }
                    if (this.aggression >= 50) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)11);
                    }
                }
            } else {
                this.field_70180_af.func_187227_b(ANNOYED, (Object)true);
                this.setAI((byte)0);
                this.setAI((byte)1);
                this.setEquipment((byte)2);
            }
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_3 * 1.0f && !this.isAnnoyed()) {
            this.field_70180_af.func_187227_b(ANNOYED, (Object)true);
            this.setAI((byte)0);
            this.setAI((byte)1);
            this.setEquipment((byte)2);
        }
        if (this.func_110143_aJ() <= EntityAttributes.MAX_HEALTH_3 * 0.25f && this.func_110143_aJ() > 0.0f && this.buffEffect == 0) {
            this.setAI((byte)2);
            this.setEquipment((byte)1);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_3 * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setAI((byte)1);
                this.setEquipment((byte)0);
                this.animationPlay = false;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70636_d();
        }
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70715_bh.func_75776_a(2, this.aiNearestAttackableTarget);
        }
        if (id == 1) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
        if (id == 2) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151055_y));
        }
        if (id == 2) {
            ItemStack shield = new ItemStack(GaiaItems.SHIELD_PROP, 1, 1);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, shield);
        }
    }

    private void setBuff() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 0));
        this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 0));
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70715_bh.func_85156_a(this.aiNearestAttackableTarget);
        if (this.isAnnoyed()) {
            this.setAI((byte)0);
            this.setAI((byte)1);
        }
    }

    private boolean playerDetection(double range) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(range);
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        return !list.isEmpty();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANNOYED, (Object)false);
    }

    public boolean isAnnoyed() {
        return (Boolean)this.field_70180_af.func_187225_a(ANNOYED);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.field_70180_af.func_187227_b(ANNOYED, (Object)compound.func_74767_n("annoyed"));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        compound.func_74757_a("annoyed", this.isAnnoyed());
        this.setCombatTask();
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.VALKYRIE_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.VALKYRIE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return GaiaSounds.VALKYRIE_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_VALKYRIE;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(4) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FOOD_SMALL_APPLE_GOLD, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                ItemShard.dropNugget((Entity)this, 2);
            }
            int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNuggetAlt; ++i) {
                ItemShard.dropNugget((Entity)this, 3);
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_DIAMOND, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.BUST_VALKYRIE), 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_70099_a(new ItemStack(GaiaItems.MISC_RING, 1, 0), 0.0f);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.setAI((byte)1);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_SWORD_IRON));
        this.func_180483_b(difficulty);
        ItemStack bootsSwimming = new ItemStack((Item)Items.field_151021_T);
        this.func_184201_a(EntityEquipmentSlot.FEET, bootsSwimming);
        bootsSwimming.func_77966_a(Enchantments.field_185300_i, 2);
        this.setCombatTask();
        return ret;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        if (GaiaConfig.SPAWN.spawnLevel3Rain) {
            return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 80.0 : 0.0) && this.field_70170_p.func_72896_J() && super.func_70601_bi();
        }
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 80.0 : 0.0) && super.func_70601_bi();
    }
}

