/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.EntityAIGaiaLeapAtTarget;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaWerecat
extends EntityMobHostileBase {
    private static final String MOB_TYPE_TAG = "MobType";
    private EntityAIGaiaLeapAtTarget aiGaiaLeapAtTarget = new EntityAIGaiaLeapAtTarget((EntityLiving)this, 0.4f);
    private EntityAIAttackMelee aiMeleeAttack = new AILeapAttack(this);
    private EntityAIAvoidEntity<EntityPlayer> aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 20.0f, 1.25, 1.3);
    private int switchHealth;
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaWerecat.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityGaiaWerecat(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 0));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.25f && this.switchHealth == 0) {
            switch (this.field_70146_Z.nextInt(2)) {
                case 0: {
                    this.setAI((byte)1);
                    this.setEquipment((byte)1);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.25f && this.switchHealth == 1) {
            this.setAI((byte)0);
            this.setEquipment((byte)0);
            this.switchHealth = 0;
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiGaiaLeapAtTarget);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a(this.aiAvoid);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiGaiaLeapAtTarget);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_75776_a(2, this.aiAvoid);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151110_aK));
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151008_G));
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
        this.field_70714_bg.func_85156_a(this.aiAvoid);
        this.setAI((byte)0);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.WERECAT_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.WERECAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.WERECAT_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_WERECAT;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FOOD_MEAT, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.setTextureType(1);
        }
        ItemStack weaponCustom = new ItemStack(GaiaItems.WEAPON_PROP_ENCHANTED, 1);
        weaponCustom.func_77966_a(Enchantments.field_180313_o, 2);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, weaponCustom);
        this.setCombatTask();
        return ret;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getTextureType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte b0 = compound.func_74771_c(MOB_TYPE_TAG);
            this.setTextureType(b0);
        }
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }

    static class AILeapAttack
    extends EntityAIAttackMelee {
        AILeapAttack(EntityGaiaWerecat entity) {
            super((EntityCreature)entity, 1.25, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0 + (double)attackTarget.field_70130_N;
        }
    }
}

