/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobAssistDay;
import gaia.entity.ai.EntityAIGaiaValidateTargetPlayer;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaYukiOnna
extends EntityMobAssistDay {
    private static final String IS_CHILD_TAG = "IsBaby";
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityGaiaYukiOnna.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIAttackMelee aiMeleeAttack = new EntityAIAttackMelee((EntityCreature)this, 1.275, true);
    private EntityAIAvoidEntity<EntityPlayer> aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 20.0f, 1.275, 1.3);
    private int switchHealth;
    private boolean isChild;

    public EntityGaiaYukiOnna(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
        this.isChild = false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIGaiaValidateTargetPlayer(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.275);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 3));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_2 * 0.25f && this.switchHealth == 0) {
            switch (this.field_70146_Z.nextInt(2)) {
                case 0: {
                    this.setAI((byte)1);
                    this.setEquipment((byte)1);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_2 * 0.25f && this.switchHealth == 1) {
            this.setAI((byte)0);
            this.setEquipment((byte)0);
            this.switchHealth = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
                this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
            }
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a(this.aiAvoid);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_75776_a(1, this.aiAvoid);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151110_aK));
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151008_G));
        }
        if (id == 2) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151110_aK));
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
        this.field_70714_bg.func_85156_a(this.aiAvoid);
        this.setAI((byte)0);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.YUKIONNA_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.YUKIONNA_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return GaiaSounds.YUKIONNA_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(GaiaSounds.NONE, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_YUKI_ONNA;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(GaiaItems.MISC_FUR, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BOX_GOLD, 1);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                ItemStack fanIce = new ItemStack(GaiaItems.WEAPON_FAN_ICE);
                fanIce.func_77966_a(Enchantments.field_180313_o, 4);
                this.func_70099_a(fanIce, 1.0f);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (!this.isChild) {
            this.setEquipmentEnchanted();
        }
        this.setCombatTask();
        return ret;
    }

    protected void setEquipmentEnchanted() {
        ItemStack weapon;
        if (this.field_70146_Z.nextInt(4) == 0) {
            weapon = new ItemStack(GaiaItems.WEAPON_FAN, 1);
            weapon.func_77966_a(Enchantments.field_180313_o, 3);
        } else {
            weapon = new ItemStack(GaiaItems.WEAPON_PROP_ENCHANTED, 1);
            weapon.func_77966_a(Enchantments.field_180313_o, 2);
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, weapon);
    }

    private void setChild(boolean isRandom, int chance) {
        if (isRandom) {
            if (this.field_70170_p.field_73012_v.nextInt(chance) == 0) {
                this.setChild(true);
            }
        } else {
            this.setChild(true);
        }
    }

    public float func_70047_e() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
        float f = itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151110_aK ? 1.74f : 0.93f;
        return f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CHILD, (Object)false);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)isChild);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(IS_CHILD_TAG, this.func_70631_g_());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(IS_CHILD_TAG)) {
            boolean b0 = compound.func_74767_n(IS_CHILD_TAG);
            this.setChild(b0);
        }
        this.setCombatTask();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected int func_190531_bD() {
        return 20;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    private boolean isSnowing() {
        if (GaiaConfig.SPAWN.spawnWeather) {
            return true;
        }
        return this.field_70170_p.func_72896_J();
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && this.isSnowing() && super.func_70601_bi();
    }
}

