/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import com.google.common.collect.Sets;
import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobProp;
import gaia.entity.monster.EntityGaiaAnt;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaSounds;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaPropAntHill
extends EntityMobProp {
    private static final String DETECTION_TAG = "Detection_Range";
    private static final String SPAWN_AMOUNT_TAG = "Spawn_Amount";
    private static final DataParameter<Integer> DETECTION = EntityDataManager.func_187226_a(EntityGaiaPropAntHill.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPAWN_AMOUNT = EntityDataManager.func_187226_a(EntityGaiaPropAntHill.class, (DataSerializer)DataSerializers.field_187192_b);
    private int spawnTime;
    private static Set<Block> spawnBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150354_m});
    private static Set<Block> blackList = Sets.newHashSet((Object[])new Block[]{GaiaBlocks.SPAWN_GUARD});

    public EntityGaiaPropAntHill(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 0.5f);
        this.field_70728_aV = 0;
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.spawnTime = 0;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            this.setDetection(8);
            this.setSpawnAmount(4);
        } else {
            this.setDetection(6);
            this.setSpawnAmount(2);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        float input = damage;
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack itemstack = player.func_184586_b(this.func_184600_cs());
            input = itemstack.func_77973_b() instanceof ItemSpade ? (input *= 8.0f) : 0.0f;
        }
        return super.func_70097_a(source, input);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (this.playerDetection()) {
            if (this.getSpawnAmount() > 0) {
                if (this.spawnTime >= 0 && this.spawnTime <= 60) {
                    ++this.spawnTime;
                } else {
                    if (!this.field_70170_p.field_72995_K) {
                        this.setSpawn((byte)0);
                    }
                    this.func_70097_a(DamageSource.field_76377_j, EntityAttributes.MAX_HEALTH_1 / (float)this.getSpawnAmount());
                    this.setSpawnAmount(this.getSpawnAmount() - 1);
                    this.spawnTime = 0;
                }
            } else {
                this.func_70106_y();
            }
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        super.func_70636_d();
    }

    private void setSpawn(byte id) {
        if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            EntityGaiaAnt ant = new EntityGaiaAnt(this.field_70170_p);
            ant.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            ant.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)ant)), null);
            ant.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151110_aK));
            this.field_70170_p.func_72838_d((Entity)ant);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
    }

    private boolean playerDetection() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g((double)this.getDetection());
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        return !list.isEmpty();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DETECTION, (Object)0);
        this.field_70180_af.func_187214_a(SPAWN_AMOUNT, (Object)0);
    }

    public int getDetection() {
        return (Integer)this.field_70180_af.func_187225_a(DETECTION);
    }

    private void setDetection(int par1) {
        this.field_70180_af.func_187227_b(DETECTION, (Object)par1);
    }

    public int getSpawnAmount() {
        return (Integer)this.field_70180_af.func_187225_a(SPAWN_AMOUNT);
    }

    private void setSpawnAmount(int par1) {
        this.field_70180_af.func_187227_b(SPAWN_AMOUNT, (Object)par1);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(DETECTION_TAG, (byte)this.getDetection());
        compound.func_74774_a(SPAWN_AMOUNT_TAG, (byte)this.getSpawnAmount());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(DETECTION_TAG)) {
            byte b0 = compound.func_74771_c(DETECTION_TAG);
            this.setDetection(b0);
        }
        if (compound.func_74764_b(SPAWN_AMOUNT_TAG)) {
            byte b1 = compound.func_74771_c(SPAWN_AMOUNT_TAG);
            this.setDetection(b1);
        }
    }

    protected void playParticleEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_LARGE;
        if (!play) {
            enumparticletypes = EnumParticleTypes.EXPLOSION_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.ANT_SAY;
    }

    protected void func_70609_aI() {
        this.func_70106_y();
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean spawnConditions() {
        float f;
        if (this.field_70170_p.func_72935_r() && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            if (EntityGaiaPropAntHill.torchCheck(this.field_70170_p, this.func_180425_c())) {
                return false;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            Block var1 = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
            HashSet<String> additionalBlocks = new HashSet<String>(Arrays.asList(GaiaConfig.SPAWN.additionalFlowerSpawnBlocks));
            boolean defaultFlag = spawnBlocks.contains(var1);
            boolean additionalFlag = !additionalBlocks.isEmpty() && additionalBlocks.contains(var1.getRegistryName().toString());
            return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && (defaultFlag || additionalFlag) && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        }
        return false;
    }

    private static boolean torchCheck(World world, BlockPos pos) {
        for (BlockPos location : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-8, -8, -8), (BlockPos)pos.func_177982_a(8, 8, 8))) {
            if (!blackList.contains(world.func_180495_p(location).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }
}

