/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.GaiaConfig;
import gaia.entity.EntityMobProp;
import gaia.entity.monster.EntityGaiaMimic;
import gaia.helpers.LootHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaPropChestMimic
extends EntityMobProp {
    private static final String ROTATION_TAG = "Rotation";
    private static final String DROP_TAG = "Drop";
    private static final DataParameter<Integer> ROTATION = EntityDataManager.func_187226_a(EntityGaiaPropChestMimic.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DROP = EntityDataManager.func_187226_a(EntityGaiaPropChestMimic.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean spawned;

    public EntityGaiaPropChestMimic(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70728_aV = 0;
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.spawned = false;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                this.setRotation(0);
                break;
            }
            case 1: {
                this.setRotation(1);
                break;
            }
            case 2: {
                this.setRotation(2);
                break;
            }
            case 3: {
                this.setRotation(3);
            }
        }
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                this.setDrop(2);
            } else {
                this.setDrop(1);
            }
        } else {
            this.setDrop(0);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (this.playerDetection() && this.getDrop() == 2) {
            if (!this.field_70170_p.field_72995_K) {
                this.setSpawn((byte)0);
            }
            this.spawned = true;
        }
        if (this.spawned) {
            this.func_70097_a(DamageSource.field_76377_j, 2.0f);
        }
        super.func_70636_d();
    }

    private void setSpawn(byte id) {
        if (id == 0 && !this.spawned && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            EntityGaiaMimic mimic = new EntityGaiaMimic(this.field_70170_p);
            mimic.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            mimic.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)mimic)), null);
            this.field_70170_p.func_72838_d((Entity)mimic);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
    }

    private boolean playerDetection() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(4.0);
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        return !list.isEmpty();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        this.func_70097_a(DamageSource.field_76377_j, 2.0f);
        return super.func_184645_a(player, hand);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROTATION, (Object)0);
        this.field_70180_af.func_187214_a(DROP, (Object)0);
    }

    public int getRotation() {
        return (Integer)this.field_70180_af.func_187225_a(ROTATION);
    }

    private void setRotation(int par1) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)par1);
    }

    public int getDrop() {
        return (Integer)this.field_70180_af.func_187225_a(DROP);
    }

    private void setDrop(int par1) {
        this.field_70180_af.func_187227_b(DROP, (Object)par1);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(ROTATION_TAG, (byte)this.getRotation());
        compound.func_74774_a(DROP_TAG, (byte)this.getDrop());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(ROTATION_TAG)) {
            byte b0 = compound.func_74771_c(ROTATION_TAG);
            this.setRotation(b0);
        }
        if (compound.func_74764_b(DROP_TAG)) {
            byte b1 = compound.func_74771_c(DROP_TAG);
            this.setDrop(b1);
        }
    }

    protected void playParticleEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_LARGE;
        if (!play) {
            enumparticletypes = EnumParticleTypes.EXPLOSION_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187657_V;
    }

    @Override
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.getDrop() == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.setSpawn((byte)0);
        } else if (this.getDrop() == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            LootHelper.dropRandomLootAtEntityPos(this.field_70170_p, this.field_70717_bb, (Entity)this, wasRecentlyHit, LootTableList.field_186422_d, 2);
        }
    }

    protected void func_70609_aI() {
        this.func_70106_y();
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    private boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < (!GaiaConfig.SPAWN.disableYRestriction ? 32.0 : 512.0) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.func_70601_bi();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }
}

