/*
 * Decompiled with CFR 0.152.
 */
package gaia.helpers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class LootHelper {
    private LootHelper() {
    }

    public static void dropLootAtPlayersPos(World world, EntityPlayer player, ResourceLocation lootTableName) {
        List<ItemStack> loot = LootHelper.getLoot(world, player, true, lootTableName);
        for (ItemStack itemstack : loot) {
            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, itemstack));
        }
    }

    private static List<ItemStack> getLoot(World world, @Nullable EntityPlayer player, boolean entityWasRecentlyHit, ResourceLocation lootTableName) {
        LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
        LootTable lootTable = world.func_184146_ak().func_186521_a(lootTableName);
        if (entityWasRecentlyHit && player != null) {
            builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
        }
        return lootTable.func_186462_a(world.field_73012_v, builder.func_186471_a());
    }

    public static void dropRandomLootAtPlayersPos(World world, EntityPlayer player, ResourceLocation lootTableName, int rolls) {
        LootHelper.dropRandomLootAtEntityPos(world, player, (Entity)player, true, lootTableName, rolls);
    }

    public static void dropRandomLootAtEntityPos(World world, @Nullable EntityPlayer player, Entity entity, boolean entityWasRecentlyHit, ResourceLocation lootTableName, int rolls) {
        List<ItemStack> loot = LootHelper.getLoot(world, player, entityWasRecentlyHit, lootTableName);
        for (int i = 0; i < rolls; ++i) {
            entity.func_70099_a(loot.get(world.field_73012_v.nextInt(loot.size())), 0.0f);
        }
    }
}

