/*
 * Decompiled with CFR 0.152.
 */
package gaia.helpers;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelLoaderHelper {
    private ModelLoaderHelper() {
    }

    public static void registerItem(Block block) {
        Item item = Item.func_150898_a((Block)block);
        ModelLoaderHelper.registerItem(item);
    }

    public static void registerItem(Item item) {
        if (item.func_77614_k()) {
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), subItems);
            for (ItemStack stack : subItems) {
                ModelLoaderHelper.registerItem(item, stack.func_77960_j());
            }
        } else {
            ModelLoaderHelper.registerItem(item, 0);
        }
    }

    private static void registerItem(Item item, int meta) {
        ModelLoaderHelper.registerItem(item, meta, "inventory");
    }

    private static void registerItem(Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    public static void registerItem(Item item, String ... variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            ModelLoaderHelper.registerItem(item, meta, variants[meta]);
        }
    }

    public static void registerItem(Item item, ModelResourceLocation ... modelLocations) {
        for (int meta = 0; meta < modelLocations.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelLocations[meta]);
        }
    }

    public static ModelResourceLocation getSuffixedLocation(Item item, String suffix) {
        return new ModelResourceLocation(item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a() + suffix, "inventory");
    }
}

