/*
 * Decompiled with CFR 0.152.
 */
package gaia.init;

import com.google.common.collect.ImmutableSet;
import gaia.GaiaConfig;
import gaia.entity.EntityMobAssist;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.EntityMobProp;
import gaia.entity.monster.EntityGaiaAntRanger;
import gaia.entity.monster.EntityGaiaAnubis;
import gaia.entity.monster.EntityGaiaArachne;
import gaia.entity.monster.EntityGaiaBanshee;
import gaia.entity.monster.EntityGaiaBaphomet;
import gaia.entity.monster.EntityGaiaBee;
import gaia.entity.monster.EntityGaiaBoneKnight;
import gaia.entity.monster.EntityGaiaCecaelia;
import gaia.entity.monster.EntityGaiaCentaur;
import gaia.entity.monster.EntityGaiaCobbleGolem;
import gaia.entity.monster.EntityGaiaCobblestoneGolem;
import gaia.entity.monster.EntityGaiaCreep;
import gaia.entity.monster.EntityGaiaDeathword;
import gaia.entity.monster.EntityGaiaDhampir;
import gaia.entity.monster.EntityGaiaDryad;
import gaia.entity.monster.EntityGaiaDullahan;
import gaia.entity.monster.EntityGaiaDwarf;
import gaia.entity.monster.EntityGaiaEnderEye;
import gaia.entity.monster.EntityGaiaFleshLich;
import gaia.entity.monster.EntityGaiaGelatinousSlime;
import gaia.entity.monster.EntityGaiaGoblin;
import gaia.entity.monster.EntityGaiaGryphon;
import gaia.entity.monster.EntityGaiaHarpy;
import gaia.entity.monster.EntityGaiaHarpyWizard;
import gaia.entity.monster.EntityGaiaHunter;
import gaia.entity.monster.EntityGaiaKikimora;
import gaia.entity.monster.EntityGaiaKobold;
import gaia.entity.monster.EntityGaiaMatango;
import gaia.entity.monster.EntityGaiaMermaid;
import gaia.entity.monster.EntityGaiaMinotaurus;
import gaia.entity.monster.EntityGaiaMonoeye;
import gaia.entity.monster.EntityGaiaMummy;
import gaia.entity.monster.EntityGaiaNaga;
import gaia.entity.monster.EntityGaiaNineTails;
import gaia.entity.monster.EntityGaiaOni;
import gaia.entity.monster.EntityGaiaOrc;
import gaia.entity.monster.EntityGaiaSatyress;
import gaia.entity.monster.EntityGaiaSelkie;
import gaia.entity.monster.EntityGaiaShaman;
import gaia.entity.monster.EntityGaiaSharko;
import gaia.entity.monster.EntityGaiaSiren;
import gaia.entity.monster.EntityGaiaSludgeGirl;
import gaia.entity.monster.EntityGaiaSpriggan;
import gaia.entity.monster.EntityGaiaSuccubus;
import gaia.entity.monster.EntityGaiaToad;
import gaia.entity.monster.EntityGaiaValkyrie;
import gaia.entity.monster.EntityGaiaWerecat;
import gaia.entity.monster.EntityGaiaWitch;
import gaia.entity.monster.EntityGaiaWitherCow;
import gaia.entity.monster.EntityGaiaYeti;
import gaia.entity.monster.EntityGaiaYukiOnna;
import gaia.entity.prop.EntityGaiaPropAntHill;
import gaia.entity.prop.EntityGaiaPropChestMimic;
import gaia.entity.prop.EntityGaiaPropFlowerCyan;
import gaia.entity.prop.EntityGaiaPropVase;
import gaia.entity.prop.EntityGaiaPropVaseNether;
import gaia.entity.prop.spawner.EntityGaiaSpawnerBeholder;
import gaia.entity.prop.spawner.EntityGaiaSpawnerEnderDragonGirl;
import gaia.entity.prop.spawner.EntityGaiaSpawnerMinotaur;
import gaia.entity.prop.spawner.EntityGaiaSpawnerSphinx;
import gaia.entity.prop.spawner.EntityGaiaSpawnerVampire;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GaiaSpawning {
    private GaiaSpawning() {
    }

    public static void add(int weight, Class<? extends EntityLiving> entityclassIn, int groupCountMin, int groupCountMax, Biome biome) {
        if (weight > 0) {
            biome.func_76747_a(EnumCreatureType.MONSTER).add(new Biome.SpawnListEntry(entityclassIn, weight, groupCountMin, groupCountMax));
        }
    }

    private static void underground(Biome biome) {
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnCreep, EntityGaiaCreep.class, 2, 4, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnEnderEye, EntityGaiaEnderEye.class, 2, 4, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnVase, EntityGaiaPropVase.class, 1, 1, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnMimic, EntityGaiaPropChestMimic.class, 1, 1, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnArachne, EntityGaiaArachne.class, 1, 2, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnDeathword, EntityGaiaDeathword.class, 1, 2, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnBoneKnight, EntityGaiaBoneKnight.class, 1, 2, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnFleshLich, EntityGaiaFleshLich.class, 1, 2, biome);
    }

    private static void aquatic(Biome biome) {
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnCecaelia, EntityGaiaCecaelia.class, 4, 6, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnMermaid, EntityGaiaMermaid.class, 2, 4, biome);
        GaiaSpawning.add(GaiaConfig.GENERAL.spawnSharko, EntityGaiaSharko.class, 2, 4, biome);
    }

    public static void register() {
        Map<BiomeDictionary.Type, Set<Biome>> biomeMap = GaiaSpawning.buildBiomeListByType();
        GaiaSpawning.addForestSPAWN(biomeMap);
        GaiaSpawning.addSandySPAWN(biomeMap);
        GaiaSpawning.addPlainsSPAWN(biomeMap);
        GaiaSpawning.addSwampSPAWN(biomeMap);
        GaiaSpawning.addJungleSPAWN(biomeMap);
        GaiaSpawning.addSnowySPAWN(biomeMap);
        GaiaSpawning.addMountainSPAWN(biomeMap);
        GaiaSpawning.addSavannaSPAWN(biomeMap);
        GaiaSpawning.addMesaSPAWN(biomeMap);
        GaiaSpawning.addWaterSPAWN(biomeMap);
        GaiaSpawning.addBeachSPAWN(biomeMap);
        GaiaSpawning.addNetherSPAWN(biomeMap);
        GaiaSpawning.addEndSPAWN(biomeMap);
    }

    private static void addEndSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.END)) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) continue;
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnBeholder, EntityGaiaSpawnerBeholder.class, 1, 1, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnEnderDragonGirl, EntityGaiaSpawnerEnderDragonGirl.class, 1, 1, biome);
        }
    }

    private static void addNetherSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.NETHER)) {
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnVaseNether, EntityGaiaPropVaseNether.class, 1, 1, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnSuccubus, EntityGaiaSuccubus.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnWitherCow, EntityGaiaWitherCow.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnBaphomet, EntityGaiaBaphomet.class, 2, 4, biome);
        }
    }

    private static void addBeachSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.BEACH)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) continue;
            GaiaSpawning.aquatic(biome);
        }
    }

    private static void addWaterSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        ImmutableSet water = new ImmutableSet.Builder().addAll((Iterable)biomeMap.get(BiomeDictionary.Type.OCEAN)).addAll((Iterable)biomeMap.get(BiomeDictionary.Type.RIVER)).build();
        for (Biome biome : water) {
            GaiaSpawning.aquatic(biome);
        }
    }

    private static void addMountainSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.MOUNTAIN)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) continue;
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnGryphon, EntityGaiaGryphon.class, 1, 2, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnDwarf, EntityGaiaDwarf.class, 4, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnValkyrie, EntityGaiaValkyrie.class, 1, 2, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnDullahan, EntityGaiaDullahan.class, 4, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnBanshee, EntityGaiaBanshee.class, 2, 4, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addSnowySPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.SNOWY)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) continue;
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnSelkie, EntityGaiaSelkie.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnKobold, EntityGaiaKobold.class, 4, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnYeti, EntityGaiaYeti.class, 2, 4, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addJungleSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.JUNGLE)) {
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnHunter, EntityGaiaHunter.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnCobbleGolem, EntityGaiaCobbleGolem.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnShaman, EntityGaiaShaman.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnCobblestoneGolem, EntityGaiaCobblestoneGolem.class, 2, 4, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addSwampSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.SWAMP)) {
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnSiren, EntityGaiaSiren.class, 4, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnNaga, EntityGaiaNaga.class, 1, 2, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnSludgeGirl, EntityGaiaSludgeGirl.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnGelatinousSlime, EntityGaiaGelatinousSlime.class, 1, 2, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addPlainsSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.PLAINS)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) continue;
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnSatyress, EntityGaiaSatyress.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnCentaur, EntityGaiaCentaur.class, 4, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnHarpy, EntityGaiaHarpy.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnMinotaurus, EntityGaiaMinotaurus.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnMinotaur, EntityGaiaSpawnerMinotaur.class, 1, 1, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addSavannaSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.SAVANNA)) {
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnGoblin, EntityGaiaGoblin.class, 2, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnOrc, EntityGaiaOrc.class, 2, 6, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addMesaSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.MESA)) {
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnSatyress, EntityGaiaSatyress.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnCentaur, EntityGaiaCentaur.class, 4, 6, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnHarpy, EntityGaiaHarpy.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnMinotaurus, EntityGaiaMinotaurus.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnMinotaur, EntityGaiaSpawnerMinotaur.class, 1, 1, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static void addSandySPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.SANDY)) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnAntHill, EntityGaiaPropAntHill.class, 1, 1, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnAntRanger, EntityGaiaAntRanger.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnMummy, EntityGaiaMummy.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnAnubis, EntityGaiaAnubis.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnSphinx, EntityGaiaSpawnerSphinx.class, 1, 1, biome);
                GaiaSpawning.underground(biome);
            }
            GaiaSpawning.underground(biome);
        }
    }

    private static void addForestSPAWN(Map<BiomeDictionary.Type, Set<Biome>> biomeMap) {
        for (Biome biome : biomeMap.get(BiomeDictionary.Type.FOREST)) {
            if (!(BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE))) {
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnDryad, EntityGaiaDryad.class, 4, 6, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnBee, EntityGaiaBee.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnMandragora, EntityGaiaPropFlowerCyan.class, 1, 1, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnWerecat, EntityGaiaWerecat.class, 4, 6, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnSpriggan, EntityGaiaSpriggan.class, 2, 4, biome);
                GaiaSpawning.underground(biome);
            }
            if (!(BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RARE))) {
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnDryad, EntityGaiaDryad.class, 4, 6, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnBee, EntityGaiaBee.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnMandragora, EntityGaiaPropFlowerCyan.class, 1, 2, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnWerecat, EntityGaiaWerecat.class, 4, 6, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnSpriggan, EntityGaiaSpriggan.class, 2, 4, biome);
                GaiaSpawning.underground(biome);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnMandragora, EntityGaiaPropFlowerCyan.class, 1, 2, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnCyclops, EntityGaiaMonoeye.class, 4, 6, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnYukiOnna, EntityGaiaYukiOnna.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnOni, EntityGaiaOni.class, 4, 6, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnNineTails, EntityGaiaNineTails.class, 2, 4, biome);
                GaiaSpawning.underground(biome);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnKikimora, EntityGaiaKikimora.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnDhampir, EntityGaiaDhampir.class, 2, 4, biome);
                GaiaSpawning.add(GaiaConfig.GENERAL.spawnVampire, EntityGaiaSpawnerVampire.class, 1, 1, biome);
                GaiaSpawning.underground(biome);
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) continue;
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnMatango, EntityGaiaMatango.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnToad, EntityGaiaToad.class, 2, 4, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnHarpyWizard, EntityGaiaHarpyWizard.class, 1, 2, biome);
            GaiaSpawning.add(GaiaConfig.GENERAL.spawnWitch, EntityGaiaWitch.class, 2, 4, biome);
            GaiaSpawning.underground(biome);
        }
    }

    private static Map<BiomeDictionary.Type, Set<Biome>> buildBiomeListByType() {
        HashMap<BiomeDictionary.Type, Set<Biome>> biomesAndTypes = new HashMap<BiomeDictionary.Type, Set<Biome>>();
        for (Biome biome : Biome.field_185377_q) {
            Set types = BiomeDictionary.getTypes((Biome)biome);
            for (BiomeDictionary.Type type : types) {
                if (!biomesAndTypes.containsKey(type)) {
                    biomesAndTypes.put(type, new HashSet());
                }
                ((Set)biomesAndTypes.get(type)).add(biome);
            }
        }
        return biomesAndTypes;
    }

    @Mod.EventBusSubscriber(modid="grimoireofgaia")
    public static class DimensionHandler {
        @SubscribeEvent
        public static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
            if ((event.getEntity() instanceof EntityMobAssist || event.getEntity() instanceof EntityMobHostileBase || event.getEntity() instanceof EntityMobProp) && GaiaConfig.DIMENSIONS.dimensionBlacklist.length > 0) {
                event.setResult(Event.Result.DEFAULT);
                for (int i : GaiaConfig.DIMENSIONS.dimensionBlacklist) {
                    if (i != event.getWorld().field_73011_w.getDimension()) continue;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }
}

