/*
 * Decompiled with CFR 0.152.
 */
package gaia.items;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import gaia.Gaia;
import gaia.items.ItemBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Range;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public abstract class ItemAccessoryBauble
extends ItemBase
implements IBauble {
    public boolean hasEffect;
    public boolean hasModifier;
    public boolean isBaublesLoaded = Gaia.isBaublesLoaded;

    ItemAccessoryBauble(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isBaublesLoaded;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack toEquip = stack.func_77979_a(1);
        if (Loader.isModLoaded((String)"baubles") && this.canEquip(toEquip, (EntityLivingBase)player)) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stackInSlot;
                ItemStack simulate = baubles.insertItem(i, toEquip, true);
                if (!simulate.func_190926_b() || !(stackInSlot = baubles.getStackInSlot(i)).func_190926_b() && !((IBauble)stackInSlot.func_77973_b()).canUnequip(stackInSlot, (EntityLivingBase)player)) continue;
                if (!world.field_72995_K) {
                    baubles.setStackInSlot(i, toEquip);
                }
                if (stackInSlot.func_190926_b()) break;
                ((IBauble)stackInSlot.func_77973_b()).onUnequipped(stackInSlot, (EntityLivingBase)player);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stackInSlot.func_77946_l());
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        if (!this.isBaublesLoaded) {
            EntityPlayer player = (EntityPlayer)entityIn;
            Range<Integer> range = this.getActiveSlotRange();
            for (int i = ((Integer)range.getMinimum()).intValue(); i <= (Integer)range.getMaximum(); ++i) {
                if (player.field_71071_by.func_70301_a(i) == stack) {
                    this.doEffect((EntityLivingBase)player, stack);
                    if (this.isModifier() && !this.hasModifier) {
                        this.applyModifier((EntityLivingBase)player, stack);
                        this.hasModifier = true;
                    }
                    if (this.hasEffect) break;
                    this.hasEffect = true;
                    break;
                }
                if (player.field_71071_by.func_70301_a(i) == stack || !this.hasEffect) continue;
                if (this.isModifier()) {
                    this.removeModifier((EntityLivingBase)player, stack);
                    this.hasModifier = false;
                }
                this.hasEffect = false;
                break;
            }
        }
    }

    public boolean isModifier() {
        return false;
    }

    public abstract void doEffect(EntityLivingBase var1, ItemStack var2);

    public abstract void applyModifier(EntityLivingBase var1, ItemStack var2);

    public abstract void removeModifier(EntityLivingBase var1, ItemStack var2);

    protected abstract Range<Integer> getActiveSlotRange();

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
            this.doEffect(player, itemstack);
        }
        if (this.isModifier() && player instanceof EntityPlayer && !player.field_70170_p.field_72995_K && !this.hasModifier) {
            this.applyModifier(player, itemstack);
            this.hasModifier = true;
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        if (this.isModifier() && player instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
            this.removeModifier(player, itemstack);
            this.hasModifier = false;
        }
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

