/*
 * Decompiled with CFR 0.152.
 */
package gaia.renderer.entity;

import gaia.entity.monster.EntityGaiaCreep;
import gaia.model.ModelGaiaCreep;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGaiaCreep
extends RenderLiving<EntityLiving> {
    private static final ResourceLocation texture = new ResourceLocation("grimoireofgaia", "textures/entity/creep.png");

    public RenderGaiaCreep(RenderManager renderManager, float shadowSize) {
        super(renderManager, (ModelBase)new ModelGaiaCreep(), shadowSize);
        this.func_177094_a(new LayerCreepCharge(this));
    }

    protected void preRenderCallback(EntityLiving entitylivingbaseIn, float partialTickTime) {
        this.preRenderCallback((EntityGaiaCreep)entitylivingbaseIn, partialTickTime);
    }

    protected int getColorMultiplier(EntityLiving entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        return this.getColorMultiplier((EntityGaiaCreep)entitylivingbaseIn, lightBrightness, partialTickTime);
    }

    protected void preRenderCallback(EntityGaiaCreep entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        GlStateManager.func_179152_a((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(EntityGaiaCreep entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    protected ResourceLocation getEntityTexture(EntityLiving entity) {
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerCreepCharge
    implements LayerRenderer<EntityGaiaCreep> {
        private static final ResourceLocation LIGHTNING_TEXTURE = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
        private final RenderGaiaCreep creeperRenderer;
        private final ModelGaiaCreep creeperModel = new ModelGaiaCreep();

        LayerCreepCharge(RenderGaiaCreep creeperRendererIn) {
            this.creeperRenderer = creeperRendererIn;
        }

        public void doRenderLayer(EntityGaiaCreep entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entitylivingbaseIn.getPowered()) {
                boolean flag = entitylivingbaseIn.func_82150_aj();
                GlStateManager.func_179132_a((!flag ? 1 : 0) != 0);
                this.creeperRenderer.func_110776_a(LIGHTNING_TEXTURE);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                float f = (float)entitylivingbaseIn.field_70173_aa + partialTicks;
                GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                this.creeperModel.func_178686_a(this.creeperRenderer.func_177087_b());
                this.creeperModel.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179132_a((boolean)flag);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

