/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.skill.agility;

import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.unlockable.Trait;
import codersafterdark.reskillable.client.base.ClientTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TraitSidestep
extends Trait {
    public static final int MAX_CD = 20;
    private int leftDown;
    private int rightDown;
    private int cd;

    public TraitSidestep() {
        super(new ResourceLocation("reskillable", "sidestep"), 3, 1, new ResourceLocation("reskillable", "agility"), 10, "reskillable:agility|26", "reskillable:defense|20");
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.cd > 0) {
            --this.cd;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyDown(InputEvent.KeyInputEvent event) {
        if (this.cd > 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!PlayerDataHandler.get((EntityPlayer)mc.field_71439_g).getSkillInfo(this.getParentSkill()).isUnlocked(this) || mc.field_71439_g.func_70093_af()) {
            return;
        }
        int threshold = 4;
        if (mc.field_71474_y.field_74370_x.func_151470_d()) {
            int oldLeft = this.leftDown;
            this.leftDown = ClientTickHandler.ticksInGame;
            if (this.leftDown - oldLeft < threshold) {
                this.dodge((EntityPlayer)mc.field_71439_g, true);
            }
        } else if (mc.field_71474_y.field_74366_z.func_151470_d()) {
            int oldRight = this.rightDown;
            this.rightDown = ClientTickHandler.ticksInGame;
            if (this.rightDown - oldRight < threshold) {
                this.dodge((EntityPlayer)mc.field_71439_g, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void dodge(EntityPlayer player, boolean left) {
        if (player.field_71075_bZ.field_75100_b || !player.field_70122_E || player.field_191988_bg >= 0.0f || !GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_151444_V)) {
            return;
        }
        float yaw = player.field_70177_z;
        float x = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float z = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        Vec3d lookVec = new Vec3d((double)x, 0.0, (double)z);
        Vec3d sideVec = lookVec.func_72431_c(new Vec3d(0.0, left ? 1.0 : -1.0, 0.0)).func_186678_a(1.25);
        player.field_70159_w = sideVec.field_72450_a;
        player.field_70181_x = sideVec.field_72448_b;
        player.field_70179_y = sideVec.field_72449_c;
        this.cd = 20;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        ScaledResolution res = event.getResolution();
        Minecraft mc = Minecraft.func_71410_x();
        int xo = res.func_78326_a() / 2 - 20;
        int y = res.func_78328_b() / 2 + 20;
        GlStateManager.func_179147_l();
        if (!mc.field_71439_g.field_71075_bZ.field_75100_b) {
            int width = Math.min((int)(((float)this.cd - event.getPartialTicks()) * 2.0f), 40);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (width > 0) {
                Gui.func_73734_a((int)xo, (int)(y - 2), (int)(xo + 40), (int)(y - 1), (int)0x44000000);
                Gui.func_73734_a((int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

