/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.blocks.IMusable;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockBranchThick
extends BlockBranchBasic
implements IMusable {
    protected static final AxisAlignedBB maxBranchBB = new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 1.0, 2.0);
    public static final int RADMAX_THICK = 24;
    protected static final PropertyInteger RADIUSNYBBLE = PropertyInteger.func_177719_a((String)"radius", (int)0, (int)15);
    protected final boolean extended;
    public BlockBranchThick otherBlock;

    public BlockBranchThick(String name) {
        this(Material.field_151575_d, name);
    }

    public BlockBranchThick(Material material, String name) {
        this(material, name, false);
        this.otherBlock = new BlockBranchThick(material, name + "x", true);
        this.otherBlock.otherBlock = this;
        this.cacheBranchThickStates();
    }

    protected BlockBranchThick(Material material, String name, boolean extended) {
        super(material, name);
        this.extended = extended;
    }

    public BlockBranchThick getPairSide(boolean ext) {
        return this.extended ^ ext ? this.otherBlock : this;
    }

    @Override
    public void cacheBranchStates() {
    }

    public void cacheBranchThickStates() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RADIUSNYBBLE, (Comparable)Integer.valueOf(0)));
        if (!this.extended) {
            this.otherBlock.branchStates = this.branchStates = new IBlockState[25];
            this.branchStates[0] = Blocks.field_150350_a.func_176223_P();
            for (int radius = 1; radius <= 24; ++radius) {
                this.branchStates[radius] = this.getPairSide(radius > 16).func_176223_P().func_177226_a((IProperty)RADIUSNYBBLE, (Comparable)Integer.valueOf(radius - 1 & 0xF));
            }
        }
    }

    @Override
    public IProperty<?>[] getIgnorableProperties() {
        return new IProperty[]{RADIUSNYBBLE};
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.extended) {
            return this.otherBlock.getPickBlock(this.otherBlock.func_176223_P(), target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public void setFamily(TreeFamily tree) {
        super.setFamily(tree);
        if (!this.extended) {
            this.otherBlock.setFamily(tree);
        }
    }

    @Override
    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{RADIUSNYBBLE};
        return new ExtendedBlockState((Block)this, listedProperties, CONNECTIONS);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)RADIUSNYBBLE, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)RADIUSNYBBLE);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            int thisRadius = this.getRadius(state);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                retval = retval.withProperty(CONNECTIONS[dir.func_176745_a()], (Object)this.getSideConnectionRadius(world, pos, thisRadius, dir));
            }
            return retval;
        }
        return state;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return blockState.func_177230_c() == this ? MathHelper.func_76125_a((int)((Integer)blockState.func_177229_b((IProperty)RADIUSNYBBLE) + (((BlockBranchThick)blockState.func_177230_c()).extended ? 17 : 1)), (int)1, (int)this.getMaxRadius()) : 0;
    }

    @Override
    public int setRadius(World world, BlockPos pos, int radius, EnumFacing originDir, int flags) {
        if (radius <= 8) {
            return super.setRadius(world, pos, radius, originDir, flags);
        }
        ReplaceableState[] repStates = new ReplaceableState[8];
        boolean setable = true;
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            ReplaceableState rep;
            BlockPos dPos = pos.func_177971_a(dir.getOffset());
            repStates[dir.ordinal()] = rep = this.getReplaceability(world, dPos, pos);
            if (rep != ReplaceableState.BLOCKING) continue;
            setable = false;
            break;
        }
        if (setable) {
            int setRadius = super.setRadius(world, pos, radius, originDir, flags);
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = pos.func_177971_a(dir.getOffset());
                ReplaceableState rep = repStates[dir.ordinal()];
                if (rep != ReplaceableState.REPLACEABLE) continue;
                world.func_180501_a(dPos, ModBlocks.blockTrunkShell.func_176223_P().func_177226_a(BlockTrunkShell.COREDIR, (Comparable)((Object)dir.getOpposite())), flags);
            }
            return setRadius;
        }
        return super.setRadius(world, pos, 8, originDir, flags);
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess world, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        if (from == this || from == this.otherBlock) {
            return this.getRadius(blockState);
        }
        return Math.min(this.getRadius(blockState), 8);
    }

    @Override
    protected int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        IBlockState blockState = blockAccess.func_180495_p(deltaPos);
        int connectionRadius = TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, blockAccess, deltaPos, this, side, radius);
        if (radius > 8) {
            if (side == EnumFacing.DOWN) {
                return connectionRadius >= radius ? 1 : 0;
            }
            if (side == EnumFacing.UP) {
                return connectionRadius >= radius ? 2 : (connectionRadius > 0 ? 1 : 0);
            }
        }
        return Math.min(8, connectionRadius);
    }

    public ReplaceableState getReplaceability(World world, BlockPos pos, BlockPos corePos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == ModBlocks.blockTrunkShell) {
            CoordUtils.Surround surr = (CoordUtils.Surround)((Object)state.func_177229_b(BlockTrunkShell.COREDIR));
            return pos.func_177971_a(surr.getOffset()).equals((Object)corePos) ? ReplaceableState.SHELL : ReplaceableState.BLOCKING;
        }
        if (block.func_176200_f((IBlockAccess)world, pos) || block instanceof BlockBush) {
            return ReplaceableState.REPLACEABLE;
        }
        if (TreeHelper.isTreePart(block)) {
            return ReplaceableState.TREEPART;
        }
        if (block instanceof BlockSurfaceRoot) {
            return ReplaceableState.TREEPART;
        }
        if (this.getFamily().getCommonSpecies().isAcceptableSoil(world, pos, state)) {
            return ReplaceableState.REPLACEABLE;
        }
        return ReplaceableState.BLOCKING;
    }

    @Override
    public int getMaxRadius() {
        return 24;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        int thisRadius = this.getRadius(state);
        if (thisRadius <= 8) {
            return super.func_185496_a(state, blockAccess, pos);
        }
        double radius = (double)thisRadius / 16.0;
        return new AxisAlignedBB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, 1.0, 0.5 + radius);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        int radius = this.getRadius(state);
        if (radius <= 8) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
            return;
        }
        BlockBranchThick.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
    }

    @Override
    public boolean isMusable() {
        return true;
    }

    static enum ReplaceableState {
        SHELL,
        REPLACEABLE,
        BLOCKING,
        TREEPART;

    }

    class BlockStateContainerCustom
    extends BlockStateContainer {
        public BlockStateContainerCustom(Block blockIn, IProperty<?> ... properties) {
            this(blockIn, properties, (ImmutableMap<IUnlistedProperty<?>, Optional<?>>)null);
        }

        protected BlockStateContainerCustom(Block blockIn, IProperty<?>[] properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
            super(blockIn, properties, unlistedProperties);
        }

        protected BlockStateContainer.StateImplementation createState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
            return new StateImplementationCachedRadius(block, properties);
        }
    }

    class StateImplementationCachedRadius
    extends BlockStateContainer.StateImplementation {
        private int radius;

        protected StateImplementationCachedRadius(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn) {
            super(blockIn, propertiesIn);
            this.radius = -1;
        }

        protected StateImplementationCachedRadius(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn, ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> propertyValueTable) {
            super(blockIn, propertiesIn, propertyValueTable);
            this.radius = -1;
        }

        int getRadius() {
            return this.radius;
        }
    }
}

