/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LeavesProperties
implements ILeavesProperties {
    public static final LeavesProperties NULLPROPERTIES = new LeavesProperties(){

        @Override
        public ILeavesProperties setTree(TreeFamily tree) {
            return this;
        }

        @Override
        public TreeFamily getTree() {
            return TreeFamily.NULLFAMILY;
        }

        @Override
        public IBlockState getPrimitiveLeaves() {
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public ItemStack getPrimitiveLeavesItemStack() {
            return ItemStack.field_190927_a;
        }

        @Override
        public ILeavesProperties setDynamicLeavesState(IBlockState state) {
            return this;
        }

        @Override
        public IBlockState getDynamicLeavesState() {
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public IBlockState getDynamicLeavesState(int hydro) {
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public ICellKit getCellKit() {
            return CellKits.NULLCELLKIT;
        }

        @Override
        public int getFlammability() {
            return 0;
        }

        @Override
        public int getFireSpreadSpeed() {
            return 0;
        }

        @Override
        public int getSmotherLeavesMax() {
            return 0;
        }

        @Override
        public int getLightRequirement() {
            return 15;
        }

        @Override
        public boolean updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            return false;
        }
    };
    protected IBlockState primitiveLeaves;
    protected ItemStack primitiveLeavesItemStack;
    protected ICellKit cellKit;
    protected TreeFamily tree = TreeFamily.NULLFAMILY;
    protected IBlockState[] dynamicLeavesBlockHydroStates = new IBlockState[5];

    private LeavesProperties() {
    }

    public LeavesProperties(IBlockState primitiveLeaves) {
        this(primitiveLeaves, new ItemStack(Item.func_150898_a((Block)primitiveLeaves.func_177230_c()), 1, primitiveLeaves.func_177230_c().func_180651_a(primitiveLeaves)));
    }

    public LeavesProperties(IBlockState primitiveLeaves, ICellKit cellKit) {
        this(primitiveLeaves, new ItemStack(Item.func_150898_a((Block)primitiveLeaves.func_177230_c()), 1, primitiveLeaves.func_177230_c().func_180651_a(primitiveLeaves)), cellKit);
    }

    public LeavesProperties(IBlockState primitiveLeaves, ItemStack primitiveLeavesItemStack) {
        this(primitiveLeaves, primitiveLeavesItemStack, TreeRegistry.findCellKit(new ResourceLocation("dynamictrees", "deciduous")));
    }

    public LeavesProperties(IBlockState primitiveLeaves, ItemStack primitiveLeavesItemStack, ICellKit cellKit) {
        this.primitiveLeaves = primitiveLeaves != null ? primitiveLeaves : ModBlocks.blockStates.air;
        this.primitiveLeavesItemStack = primitiveLeavesItemStack != null ? primitiveLeavesItemStack : ItemStack.field_190927_a;
        this.cellKit = cellKit;
    }

    @Override
    public IBlockState getPrimitiveLeaves() {
        return this.primitiveLeaves;
    }

    @Override
    public ItemStack getPrimitiveLeavesItemStack() {
        return this.primitiveLeavesItemStack;
    }

    @Override
    public ILeavesProperties setDynamicLeavesState(IBlockState state) {
        this.dynamicLeavesBlockHydroStates[0] = Blocks.field_150350_a.func_176223_P();
        for (int i = 1; i <= 4; ++i) {
            this.dynamicLeavesBlockHydroStates[i] = state.func_177226_a((IProperty)BlockDynamicLeaves.HYDRO, (Comparable)Integer.valueOf(i));
        }
        return this;
    }

    @Override
    public IBlockState getDynamicLeavesState() {
        return this.dynamicLeavesBlockHydroStates[4];
    }

    @Override
    public IBlockState getDynamicLeavesState(int hydro) {
        return this.dynamicLeavesBlockHydroStates[MathHelper.func_76125_a((int)hydro, (int)0, (int)4)];
    }

    @Override
    public ILeavesProperties setTree(TreeFamily tree) {
        this.tree = tree;
        return this;
    }

    @Override
    public TreeFamily getTree() {
        return this.tree;
    }

    @Override
    public int getFlammability() {
        return 60;
    }

    @Override
    public int getFireSpreadSpeed() {
        return 30;
    }

    @Override
    public int getSmotherLeavesMax() {
        return 4;
    }

    @Override
    public int getLightRequirement() {
        return 13;
    }

    @Override
    public ICellKit getCellKit() {
        return this.cellKit;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Minecraft.func_71410_x().func_184125_al().func_186724_a(this.getPrimitiveLeaves(), world, pos, 0);
    }

    @Override
    public boolean updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        return true;
    }

    @Override
    public boolean appearanceChangesWithHydro() {
        return false;
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return fromRadius == 1 && from.getFamily().isCompatibleDynamicLeaves(blockAccess.func_180495_p(pos), blockAccess, pos) ? 1 : 0;
    }
}

