/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.chest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.chest.ChestItem;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.gottschcore.json.JSMin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class ChestSheetLoader {
    public static final String BUILT_IN_CHEST_SHEET_PATH = "/chestsheet.json";
    public static final String BUILT_IN_CHEST_SHEET_SUB_FOLDER = "/chestSheets/";
    private static final ChestSheet EMPTY_SHEET = new ChestSheet();

    public static ChestSheet load() throws Exception {
        ChestSheet chestSheet = null;
        InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(BUILT_IN_CHEST_SHEET_PATH);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type chestItemsType = new TypeToken<Map<String, ChestItem>>(){}.getType();
        gsonBuilder.registerTypeAdapter(chestItemsType, (Object)new ChestItemDeserializer());
        Gson gson = gsonBuilder.create();
        try {
            chestSheet = (ChestSheet)gson.fromJson(jsonReader, ChestSheet.class);
            Dungeons2.log.debug("Loaded chestSheet:" + chestSheet);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load chest sheet.");
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in chest sheet.");
            }
        }
        return chestSheet;
    }

    public static ChestSheet loadAll() throws Exception {
        Path defaultSheetPath = Paths.get(ModConfig.dungeonsFolder, "chestSheet.json").toAbsolutePath();
        Dungeons2.log.debug("Sheets Folder:" + defaultSheetPath.toString());
        ChestSheet sheet = ChestSheetLoader.load(defaultSheetPath.toString());
        if (sheet == null || sheet == EMPTY_SHEET) {
            Dungeons2.log.warn("Unable to locate default style sheet at location " + defaultSheetPath.toString());
            return EMPTY_SHEET;
        }
        Files.newDirectoryStream(Paths.get(ModConfig.dungeonsFolder, BUILT_IN_CHEST_SHEET_SUB_FOLDER), path -> path.toString().endsWith(".json")).forEach(path -> {
            try {
                ChestSheet s = ChestSheetLoader.load(path.toString());
                if (sheet.getContainers() != null && s.getContainers() != null) {
                    sheet.getContainers().putAll(s.getContainers());
                }
                if (sheet.getGroups() != null && s.getGroups() != null) {
                    sheet.getGroups().putAll(s.getGroups());
                }
                if (sheet.getItems() != null && s.getItems() != null) {
                    sheet.getItems().putAll(s.getItems());
                }
            }
            catch (Exception e) {
                Dungeons2.log.error("Unable to load additional chest sheet " + path.toString(), (Throwable)e);
            }
        });
        return sheet;
    }

    public static ChestSheet load(String filePath) throws Exception {
        ChestSheet chestSheet = null;
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            Dungeons2.log.warn("Unable to locate chest sheet using path: " + filePath);
            return EMPTY_SHEET;
        }
        FileInputStream is = new FileInputStream(path.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin((InputStream)is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type chestItemsType = new TypeToken<Map<String, ChestItem>>(){}.getType();
        gsonBuilder.registerTypeAdapter(chestItemsType, (Object)new ChestItemDeserializer());
        Gson gson = gsonBuilder.create();
        try {
            chestSheet = (ChestSheet)gson.fromJson(jsonReader, ChestSheet.class);
            Dungeons2.log.debug("Loaded chestSheet:" + chestSheet);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load chest sheet.");
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in chest sheet.");
            }
        }
        return chestSheet;
    }

    public static boolean hasChestSheet(String filePath) {
        Path path = Paths.get(ModConfig.chestSheetFile, new String[0]).toAbsolutePath();
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean hasChestSheet(Path path) {
        return Files.exists(path.toAbsolutePath(), new LinkOption[0]);
    }

    public static void exposeChestSheet(String filePath) {
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(BUILT_IN_CHEST_SHEET_PATH);
            try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                int r;
                byte[] buf = new byte[2048];
                while ((r = is.read(buf)) != -1) {
                    fos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                Dungeons2.log.error("Error exposing chestsheet resource to file system.");
            }
        }
    }

    public static class ChestItemDeserializer
    implements JsonDeserializer<Map<String, ChestItem>> {
        public Map<String, ChestItem> deserialize(JsonElement jsonElement, Type typeOfSrc, JsonDeserializationContext context) {
            HashMap<String, ChestItem> map = new HashMap<String, ChestItem>();
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                ChestItem item = new ChestItem((String)entry.getKey(), element.get("name").getAsString());
                if (element.get("damage") != null) {
                    item.setDamage(element.get("damage").getAsInt());
                }
                if (element.get("type") != null) {
                    item.setType(element.get("type").getAsString());
                }
                map.put((String)entry.getKey(), item);
            }
            return map;
        }
    }
}

