/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.command;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.builder.DungeonBuilderTopDown;
import com.someguyssoftware.dungeons2.generator.DungeonGenerator;
import com.someguyssoftware.dungeons2.generator.IRoomGenerator;
import com.someguyssoftware.dungeons2.generator.RoomGeneratorFactory;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.printer.RoomPrettyPrinter;
import com.someguyssoftware.dungeons2.style.LayoutAssigner;
import com.someguyssoftware.dungeons2.style.RoomDecorator;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class BuildEntranceCommand
extends CommandBase {
    public String func_71517_b() {
        return "dgn2entrance";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/dgn2entrance <x> <y> <z> [terrianCheck] : generates the dungeon entrance at location (x,y,z)";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        EntityPlayer player = (EntityPlayer)commandSender.func_174793_f();
        try {
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String terrainCheck = "0";
            if (args.length > 3) {
                terrainCheck = args[3];
            }
            if (player != null) {
                World world = commandSender.func_130014_f_();
                Dungeons2.log.info(String.format("Buidling Dungeons2! entrance @ %d %d %d...", x, y, z));
                DungeonBuilderTopDown builder = new DungeonBuilderTopDown(null);
                Coords startPoint = new Coords(x, y, z);
                Random random = new Random();
                Room entranceRoom = builder.buildEntranceRoom(world, random, (ICoords)startPoint);
                DungeonGenerator gen = new DungeonGenerator();
                ArrayListMultimap roomGenerators = ArrayListMultimap.create();
                LayoutAssigner layoutAssigner = new LayoutAssigner(gen.getDefaultStyleSheet());
                RoomDecorator roomDecorator = new RoomDecorator(gen.getDefaultChestSheet(), gen.getDefaultSpawnSheet());
                RoomGeneratorFactory factory = new RoomGeneratorFactory((Multimap<String, IRoomGenerator>)roomGenerators);
                LevelConfig entranceLevelConfig = new LevelConfig();
                entranceLevelConfig.setDecayMultiplier(Math.min(1, entranceLevelConfig.getDecayMultiplier()));
                layoutAssigner.assign(random, entranceRoom);
                IRoomGenerator roomGen = factory.createRoomGenerator(random, entranceRoom, false);
                roomGen.generate(world, random, entranceRoom, gen.getDefaultStyleSheet().getThemes().get(0), gen.getDefaultStyleSheet(), entranceLevelConfig);
                roomDecorator.decorate(world, random, roomGen.getGenerationStrategy().getBlockProvider(), entranceRoom, entranceLevelConfig);
                RoomPrettyPrinter printer = new RoomPrettyPrinter();
                if (entranceRoom != null) {
                    String s = printer.print(entranceRoom);
                    Dungeons2.log.info(s);
                } else {
                    Dungeons2.log.debug("Exit was null ?");
                }
            }
        }
        catch (Exception e) {
            player.func_145747_a((ITextComponent)new TextComponentString("Error:  " + e.getMessage()));
            Dungeons2.log.error("Error generating Dungeons2! dungeon:", (Throwable)e);
            e.printStackTrace();
        }
    }
}

