/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.chest.ChestSheetLoader;
import com.someguyssoftware.dungeons2.generator.IRoomGenerator;
import com.someguyssoftware.dungeons2.generator.RoomGeneratorFactory;
import com.someguyssoftware.dungeons2.model.Dungeon;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.Level;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.model.Shaft;
import com.someguyssoftware.dungeons2.spawner.SpawnSheet;
import com.someguyssoftware.dungeons2.spawner.SpawnSheetLoader;
import com.someguyssoftware.dungeons2.style.BossRoomDecorator;
import com.someguyssoftware.dungeons2.style.IRoomDecorator;
import com.someguyssoftware.dungeons2.style.LayoutAssigner;
import com.someguyssoftware.dungeons2.style.LibraryRoomDecorator;
import com.someguyssoftware.dungeons2.style.RoomDecorator;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.StyleSheetLoader;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.chest.BossLootLoader;
import com.someguyssoftware.dungeonsengine.chest.LootLoader;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;

public class DungeonGenerator {
    private static StyleSheet defaultStyleSheet;
    private static ChestSheet defaultChestSheet;
    private static SpawnSheet defaultSpawnSheet;
    private static Multimap<String, IRoomGenerator> roomGenerators;

    public DungeonGenerator() throws Exception {
        if (defaultStyleSheet == null) {
            this.setDefaultStyleSheet(StyleSheetLoader.load());
        }
        if (defaultChestSheet == null) {
            DungeonGenerator.setDefaultChestSheet(ChestSheetLoader.load());
        }
        if (defaultSpawnSheet == null) {
            DungeonGenerator.setDefaultSpawnSheet(SpawnSheetLoader.load());
        }
    }

    public boolean generate(World world, Random random, Dungeon dungeon, StyleSheet styleSheet, @Deprecated ChestSheet chestSheet, SpawnSheet spawnSheet) throws FileNotFoundException {
        if (styleSheet == null) {
            Dungeons2.log.warn("Provided style sheet is null. Using default style sheet.");
            styleSheet = DungeonGenerator.getDefaultStyleSheet();
        }
        RoomGeneratorFactory factory = new RoomGeneratorFactory(roomGenerators);
        IRoomGenerator roomGen = null;
        LayoutAssigner layoutAssigner = new LayoutAssigner(styleSheet);
        RoomDecorator roomDecorator = new RoomDecorator(new LootLoader(), spawnSheet);
        BossRoomDecorator bossRoomDecorator = new BossRoomDecorator(new BossLootLoader());
        LibraryRoomDecorator libraryDecorator = new LibraryRoomDecorator(new LootLoader(), spawnSheet);
        this.buildEntrance(world, random, dungeon, layoutAssigner, factory, roomDecorator, styleSheet);
        int levelCount = 0;
        int libraryCount = 0;
        for (Level level : dungeon.getLevels()) {
            Dungeons2.log.debug("Level -> {} ", (Object)levelCount);
            Theme levelTheme = null;
            levelTheme = level.getConfig().getTheme() != null && !level.getConfig().getTheme().equals("") ? styleSheet.getThemes().get(level.getConfig().getTheme()) : dungeon.getTheme();
            for (Room room : level.getRooms()) {
                layoutAssigner.assign(random, room);
                roomGen = factory.createRoomGenerator(random, room, level.getConfig().isSupport());
                roomGen.generate(world, random, room, levelTheme, styleSheet, level.getConfig());
                if (room.getType() == Room.Type.BOSS) {
                    Dungeons2.log.debug("Boss Room @ {}", (Object)room.getCoords());
                    bossRoomDecorator.decorate(world, random, roomGen.getGenerationStrategy().getBlockProvider(), room, level.getConfig());
                    continue;
                }
                if (room.getWidth() > 5 && room.getDepth() > 5 && room.getHeight() >= 5 && !room.hasPillar() && random.nextInt(100) < 10 && libraryCount < 3) {
                    Dungeons2.log.debug("Using library decorator for room @ " + room.getCoords().toShortString());
                    libraryDecorator.decorate(world, random, roomGen.getGenerationStrategy().getBlockProvider(), room, level.getConfig());
                    ++libraryCount;
                    continue;
                }
                roomDecorator.decorate(world, random, roomGen.getGenerationStrategy().getBlockProvider(), room, level.getConfig());
            }
            ArrayList<Hallway> generatedHallways = new ArrayList<Hallway>();
            for (Hallway hallway : level.getHallways()) {
                layoutAssigner.assign(random, hallway);
                roomGen = factory.createHallwayGenerator(hallway, level.getRooms(), generatedHallways, level.getConfig().isSupport());
                roomGen.generate(world, random, (Room)hallway, levelTheme, styleSheet, level.getConfig());
                generatedHallways.add(hallway);
            }
            for (Shaft shaft : level.getShafts()) {
                shaft.setLayout(shaft.getParent().getLayout());
                roomGen = factory.createShaftGenerator(shaft, level.getConfig().isSupport());
                roomGen.generate(world, random, (Room)shaft, levelTheme, styleSheet, level.getConfig());
            }
            ++levelCount;
        }
        return true;
    }

    private void buildEntrance(World world, Random random, Dungeon dungeon, LayoutAssigner layoutAssigner, RoomGeneratorFactory factory, IRoomDecorator roomDecorator, StyleSheet styleSheet) {
        Room entranceRoom = dungeon.getEntrance();
        Dungeons2.log.debug("Dungeon -> {}", (Object)dungeon);
        Dungeons2.log.debug("Levels -> {}", dungeon.getLevels());
        Dungeons2.log.debug("Levels.size -> {}", (Object)dungeon.getLevels().size());
        Dungeons2.log.debug("Levels[0].config -> {}", (Object)dungeon.getLevels().get(0).getConfig());
        ILevelConfig entranceLevelConfig = dungeon.getLevels().get(0).getConfig().copy();
        entranceLevelConfig.setDecayMultiplier(Math.min(5, entranceLevelConfig.getDecayMultiplier()));
        layoutAssigner.assign(random, entranceRoom);
        IRoomGenerator roomGen = factory.createRoomGenerator(random, entranceRoom, dungeon.getLevels().get(0).getConfig().isSupport());
        roomGen.generate(world, random, entranceRoom, dungeon.getTheme(), styleSheet, entranceLevelConfig);
        roomDecorator.decorate(world, random, roomGen.getGenerationStrategy().getBlockProvider(), entranceRoom, entranceLevelConfig);
    }

    public static StyleSheet getDefaultStyleSheet() {
        return defaultStyleSheet;
    }

    private void setDefaultStyleSheet(StyleSheet defaultStyleSheet) {
        DungeonGenerator.defaultStyleSheet = defaultStyleSheet;
    }

    public static ChestSheet getDefaultChestSheet() {
        return defaultChestSheet;
    }

    public static void setDefaultChestSheet(ChestSheet defaultChestSheet) {
        DungeonGenerator.defaultChestSheet = defaultChestSheet;
    }

    public static SpawnSheet getDefaultSpawnSheet() {
        return defaultSpawnSheet;
    }

    public static void setDefaultSpawnSheet(SpawnSheet defaultSpawnSheet) {
        DungeonGenerator.defaultSpawnSheet = defaultSpawnSheet;
    }

    static {
        roomGenerators = ArrayListMultimap.create();
    }
}

