/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.chest.ChestCategory;
import com.someguyssoftware.dungeons2.chest.ChestContainer;
import com.someguyssoftware.dungeons2.chest.ChestPopulator;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.generator.Location;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.RoomDecorator;
import com.someguyssoftware.dungeonsengine.chest.ILootLoader;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BossRoomDecorator
extends RoomDecorator {
    private static final int CARPET_PERCENT_CHANCE = 75;
    private ChestPopulator chestPopulator;
    private ILootLoader lootLoader;

    public BossRoomDecorator(ChestSheet chestSheet) {
    }

    public BossRoomDecorator(ILootLoader loader) {
        this.setLootLoader(loader);
    }

    @Override
    public void decorate(World world, Random random, IDungeonsBlockProvider provider, Room room, ILevelConfig config) {
        EnumFacing facing;
        Location location;
        Dungeons2.log.debug("In Boos Room Decorator.");
        List surfaceAirZone = room.getFloorMap().entries().stream().filter(x -> ((DesignElement)((Object)((Object)x.getKey()))).getFamily() == DesignElement.SURFACE_AIR).collect(Collectors.toList());
        if (surfaceAirZone == null || surfaceAirZone.size() == 0) {
            return;
        }
        List wallZone = null;
        List floorZone = null;
        floorZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.FLOOR_AIR).collect(Collectors.toList());
        EnumDyeColor dye = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        IBlockState carpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)dye);
        for (Map.Entry entry : floorZone) {
            if (random.nextInt(100) >= 75) continue;
            DesignElement elem = (DesignElement)((Object)entry.getKey());
            ICoords coords = (ICoords)entry.getValue();
            if (!this.hasSupport(world, coords, elem, provider.getLocation(coords, room, room.getLayout()))) continue;
            world.func_180501_a(coords.toPos(), carpet, 3);
        }
        wallZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.WALL_AIR).collect(Collectors.toList());
        for (int i = 0; i < 4; ++i) {
            EntityPainting entityhanging;
            Map.Entry entry;
            entry = (Map.Entry)wallZone.get(random.nextInt(wallZone.size()));
            ICoords coords = (ICoords)entry.getValue();
            location = provider.getLocation(coords, room, room.getLayout());
            facing = location.getFacing();
            if (location != null && (entityhanging = new EntityPainting(world, coords.toPos(), facing)) != null && entityhanging.func_70518_d() && WorldInfo.isServerSide((World)world)) {
                entityhanging.func_184523_o();
                world.func_72838_d((Entity)entityhanging);
            }
            wallZone.remove(entry);
        }
        Map.Entry floorEntry = (Map.Entry)floorZone.get(random.nextInt(floorZone.size()));
        DesignElement elem = (DesignElement)((Object)floorEntry.getKey());
        ICoords chestCoords = (ICoords)floorEntry.getValue();
        if (this.hasSupport(world, chestCoords, elem, location = provider.getLocation(chestCoords, room, room.getLayout()))) {
            facing = this.orientChest(location);
            world.func_180501_a(chestCoords.toPos(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 3);
            floorZone.remove(floorEntry);
        } else {
            Dungeons2.log.debug("Boss Chest has no floor support");
            chestCoords = null;
        }
        if (chestCoords != null) {
            Dungeons2.log.debug("Adding boss chest @ " + chestCoords.toShortString());
            this.getLootLoader().fill(world, random, chestCoords, config.getChestConfig());
        }
    }

    @Override
    @Deprecated
    public void decorate(World world, Random random, IDungeonsBlockProvider provider, Room room, LevelConfig config) {
        EnumFacing facing;
        Location location;
        Dungeons2.log.debug("In Boos Room Decorator.");
        List surfaceAirZone = room.getFloorMap().entries().stream().filter(x -> ((DesignElement)((Object)((Object)x.getKey()))).getFamily() == DesignElement.SURFACE_AIR).collect(Collectors.toList());
        if (surfaceAirZone == null || surfaceAirZone.size() == 0) {
            return;
        }
        List wallZone = null;
        List floorZone = null;
        floorZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.FLOOR_AIR).collect(Collectors.toList());
        EnumDyeColor dye = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        IBlockState carpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)dye);
        for (Map.Entry entry : floorZone) {
            if (random.nextInt(100) >= 75) continue;
            DesignElement elem = (DesignElement)((Object)entry.getKey());
            ICoords coords = (ICoords)entry.getValue();
            if (!this.hasSupport(world, coords, elem, provider.getLocation(coords, room, room.getLayout()))) continue;
            world.func_180501_a(coords.toPos(), carpet, 3);
        }
        wallZone = surfaceAirZone.stream().filter(f -> f.getKey() == DesignElement.WALL_AIR).collect(Collectors.toList());
        for (int i = 0; i < 4; ++i) {
            EntityPainting entityhanging;
            Map.Entry entry;
            entry = (Map.Entry)wallZone.get(random.nextInt(wallZone.size()));
            ICoords coords = (ICoords)entry.getValue();
            location = provider.getLocation(coords, room, room.getLayout());
            facing = location.getFacing();
            if (location != null && (entityhanging = new EntityPainting(world, coords.toPos(), facing)) != null && entityhanging.func_70518_d() && WorldInfo.isServerSide((World)world)) {
                entityhanging.func_184523_o();
                world.func_72838_d((Entity)entityhanging);
            }
            wallZone.remove(entry);
        }
        Map.Entry floorEntry = (Map.Entry)floorZone.get(random.nextInt(floorZone.size()));
        DesignElement elem = (DesignElement)((Object)floorEntry.getKey());
        ICoords chestCoords = (ICoords)floorEntry.getValue();
        if (this.hasSupport(world, chestCoords, elem, location = provider.getLocation(chestCoords, room, room.getLayout()))) {
            facing = this.orientChest(location);
            world.func_180501_a(chestCoords.toPos(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 3);
            floorZone.remove(floorEntry);
        } else {
            Dungeons2.log.debug("Boss Chest has no floor support");
            chestCoords = null;
        }
        if (chestCoords != null) {
            Dungeons2.log.debug("Adding boss chest @ " + chestCoords.toShortString());
            TileEntityChest inventory = this.chestPopulator.getChestTileEntity(world, chestCoords);
            if (inventory != null) {
                String chestCategory = ChestCategory.EPIC.name().toLowerCase();
                Dungeons2.log.debug("Chest category:" + chestCategory);
                List containers = (List)this.chestPopulator.getMap().get((Object)chestCategory);
                Dungeons2.log.debug("Containers found:" + containers.size());
                if (containers != null && !containers.isEmpty()) {
                    ChestContainer chest = (ChestContainer)containers.get(random.nextInt(containers.size()));
                    this.chestPopulator.populate(random, (IInventory)inventory, chest);
                }
            } else {
                Dungeons2.log.debug("Chest does not have iinventory.");
            }
        }
    }

    @Override
    public ILootLoader getLootLoader() {
        return this.lootLoader;
    }

    @Override
    public void setLootLoader(ILootLoader loader) {
        this.lootLoader = loader;
    }
}

