/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.chest;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeonsengine.chest.ILootLoader;
import com.someguyssoftware.dungeonsengine.config.IChestConfig;
import com.someguyssoftware.dungeonsengine.config.LootTableMethod;
import com.someguyssoftware.gottschcore.enums.Rarity;
import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class BossLootLoader
implements ILootLoader {
    @Override
    public void fill(World world, IInventory inventory, IChestConfig config, Random random) {
    }

    @Override
    public void fill(World world, Random random, TileEntityChest entity, IChestConfig config) {
    }

    @Override
    public void fill(World world, Random random, ICoords coords, IChestConfig config) {
        TileEntity te = world.func_175625_s(coords.toPos());
        if (te == null) {
            Dungeons2.log.warn("Unable to locate Chest TileEntity @: " + coords.toShortString());
            return;
        }
        if (te instanceof TileEntityChest) {
            if (config != null && config.getLootTableMethod() == LootTableMethod.CUSTOM) {
                List<LootTable> lootTables = Dungeons2.LOOT_TABLES.getLootTableByRarity(Rarity.BOSS);
                if (lootTables != null) {
                    Dungeons2.log.debug("found loot tables -> {}", (Object)lootTables.size());
                    int index = RandomHelper.randomInt((Random)random, (int)0, (int)(lootTables.size() - 1));
                    LootTable table = lootTables.get(index);
                    table.fillInventory((IInventory)((TileEntityChest)te), random, Dungeons2.LOOT_TABLES.getContext());
                } else {
                    Dungeons2.log.debug("did not find any loot tables by rarity -> {}", (Object)Rarity.BOSS);
                }
            }
        } else {
            Dungeons2.log.warn(String.format("TileEntity is not an instance of TileEntityChest @ %s", coords.toShortString()));
        }
    }
}

