/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.config;

import com.someguyssoftware.dungeonsengine.config.DungeonSize;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.dungeonsengine.config.LevelConfig;
import com.someguyssoftware.gottschcore.Quantity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DungeonConfig
implements IDungeonConfig {
    private String name;
    private String version = "1.0.0";
    private DungeonSize size = DungeonSize.MEDIUM;
    private Quantity numLevels = new Quantity(4.0, 7.0);
    private int bottomLimit = 5;
    private int topLimit = 235;
    private Integer surfaceBuffer = 7;
    private List<String> biomeWhiteList;
    private List<String> biomeBlackList;
    private double boundaryFactor = 1.0;
    private ILevelConfig[] levelConfigs = new ILevelConfig[]{new LevelConfig()};
    private ILevelConfig surfaceConfig;
    private boolean minecraftConstraints = true;

    public DungeonConfig() {
        this.biomeWhiteList = new ArrayList<String>();
        this.biomeBlackList = new ArrayList<String>();
    }

    @Override
    public Quantity getNumLevels() {
        return this.numLevels;
    }

    @Override
    public void setNumLevels(Quantity num) {
        this.numLevels = num;
    }

    @Override
    public int getTopLimit() {
        return this.topLimit;
    }

    @Override
    public void setTopLimit(int limit) {
        this.topLimit = limit;
    }

    @Override
    public int getBottomLimit() {
        return this.bottomLimit;
    }

    @Override
    public void setBottomLimit(int limit) {
        this.bottomLimit = limit;
    }

    @Override
    public ILevelConfig[] getLevelConfigs() {
        return this.levelConfigs;
    }

    @Override
    public void setLevelConfigs(ILevelConfig[] configs) {
        this.levelConfigs = configs;
    }

    @Override
    public Integer getSurfaceBuffer() {
        return this.surfaceBuffer;
    }

    @Override
    public void setSurfaceBuffer(Integer surfaceBuffer) {
        this.surfaceBuffer = surfaceBuffer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DungeonSize getSize() {
        return this.size;
    }

    @Override
    public void setSize(DungeonSize size) {
        this.size = size;
    }

    @Override
    public List<String> getBiomeWhiteList() {
        return this.biomeWhiteList;
    }

    @Override
    public void setBiomeWhiteList(List<String> biomeWhiteList) {
        this.biomeWhiteList = biomeWhiteList;
    }

    @Override
    public List<String> getBiomeBlackList() {
        return this.biomeBlackList;
    }

    @Override
    public void setBiomeBlackList(List<String> biomeBlackList) {
        this.biomeBlackList = biomeBlackList;
    }

    @Override
    public double getBoundaryFactor() {
        return this.boundaryFactor;
    }

    @Override
    public void setBoundaryFactor(double factor) {
        this.boundaryFactor = factor;
    }

    @Override
    public ILevelConfig getSurfaceConfig() {
        return this.surfaceConfig;
    }

    @Override
    public void setSurfaceConfig(ILevelConfig surfaceConfig) {
        this.surfaceConfig = surfaceConfig;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "DungeonConfig [name=" + this.name + ", version=" + this.version + ", size=" + (Object)((Object)this.size) + ", numLevels=" + this.numLevels + ", bottomLimit=" + this.bottomLimit + ", topLimit=" + this.topLimit + ", surfaceBuffer=" + this.surfaceBuffer + ", biomeWhiteList=" + this.biomeWhiteList + ", biomeBlackList=" + this.biomeBlackList + ", boundaryFactor=" + this.boundaryFactor + ", levelConfigs=" + Arrays.toString(this.levelConfigs) + ", surfaceConfig=" + this.surfaceConfig + "]";
    }

    @Override
    public boolean isMinecraftConstraints() {
        return this.minecraftConstraints;
    }

    @Override
    public void setMinecraftConstraints(boolean minecraftConstraints) {
        this.minecraftConstraints = minecraftConstraints;
    }
}

