/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.config;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeonsengine.config.DungeonConfigLoader;
import com.someguyssoftware.dungeonsengine.config.DungeonSize;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class DungeonConfigManager {
    public static Table<Integer, DungeonSize, List<IDungeonConfig>> DUNGEON_CONFIG_TABLE = HashBasedTable.create();
    public static IDungeonConfig DEFAULT_CONFIG;

    public DungeonConfigManager() {
        Dungeons2.log.debug("instansiating DungeonConfigManager...");
        try {
            DEFAULT_CONFIG = DungeonConfigLoader.loadDefault();
        }
        catch (Exception e) {
            Dungeons2.log.error((Object)e);
        }
        List<IDungeonConfig> configs = DungeonConfigLoader.loadAll();
        for (IDungeonConfig c : configs) {
            Integer biomeID;
            Biome biome;
            Iterator iterator;
            Object biomes;
            if (c.getBiomeWhiteList().contains("*") || c.getBiomeWhiteList().isEmpty() && c.getBiomeBlackList().isEmpty()) {
                biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
                iterator = biomes.iterator();
                while (iterator.hasNext()) {
                    biome = (Biome)iterator.next();
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                    biomeID = Biome.func_185362_a((Biome)biome);
                    if (!DUNGEON_CONFIG_TABLE.contains((Object)biomeID, (Object)c.getSize())) {
                        DUNGEON_CONFIG_TABLE.put((Object)biomeID, (Object)c.getSize(), new ArrayList(3));
                    }
                    ((List)DUNGEON_CONFIG_TABLE.get((Object)biomeID, (Object)c.getSize())).add(c);
                }
                continue;
            }
            if (!c.getBiomeWhiteList().isEmpty()) {
                for (String b : c.getBiomeWhiteList()) {
                    String biomeName = b.trim().toLowerCase();
                    Biome biome2 = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
                    if (BiomeDictionary.hasType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome2, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                    Integer biomeID2 = Biome.func_185362_a((Biome)biome2);
                    if (!DUNGEON_CONFIG_TABLE.contains((Object)biomeID2, (Object)c.getSize())) {
                        DUNGEON_CONFIG_TABLE.put((Object)biomeID2, (Object)c.getSize(), new ArrayList(3));
                    }
                    ((List)DUNGEON_CONFIG_TABLE.get((Object)biomeID2, (Object)c.getSize())).add(c);
                }
                continue;
            }
            if (c.getBiomeBlackList().isEmpty()) continue;
            biomes = (List)ForgeRegistries.BIOMES.getValuesCollection();
            iterator = biomes.iterator();
            while (iterator.hasNext()) {
                biome = (Biome)iterator.next();
                if (c.getBiomeBlackList().contains(biome.func_185359_l().toLowerCase()) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                biomeID = Biome.func_185362_a((Biome)biome);
                if (!DUNGEON_CONFIG_TABLE.contains((Object)biomeID, (Object)c.getSize())) {
                    DUNGEON_CONFIG_TABLE.put((Object)biomeID, (Object)c.getSize(), new ArrayList(3));
                }
                ((List)DUNGEON_CONFIG_TABLE.get((Object)biomeID, (Object)c.getSize())).add(c);
            }
        }
    }

    public List<IDungeonConfig> getByBiome(Integer biomeID) {
        ArrayList<IDungeonConfig> list = new ArrayList<IDungeonConfig>();
        for (List configList : DUNGEON_CONFIG_TABLE.row((Object)biomeID).values()) {
            list.addAll(configList);
        }
        return list;
    }
}

