/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.graph;

import com.someguyssoftware.dungeonsengine.graph.Waypoint;
import com.someguyssoftware.gottschcore.enums.Alignment;

public class Wayline {
    private Waypoint point1;
    private Waypoint point2;
    private Alignment alignment;
    private Wayline wayline;

    public Wayline() {
    }

    public Wayline(Waypoint point1, Waypoint point2) {
        this();
        this.point1 = point1;
        this.point2 = point2;
        if (point1.getZ() == point2.getZ()) {
            this.setAlignment(Alignment.HORIZONTAL);
        } else {
            this.setAlignment(Alignment.VERTICAL);
        }
    }

    public Wayline(Waypoint point1, Waypoint point2, Alignment alignment) {
        this(point1, point2);
        this.setAlignment(alignment);
    }

    public Wayline(Waypoint point1, Waypoint point2, Alignment alignment, Wayline line) {
        this(point1, point2, alignment);
        this.setWayline(line);
    }

    public Waypoint getPoint1() {
        return this.point1;
    }

    public void setPoint1(Waypoint point1) {
        this.point1 = point1;
    }

    public Waypoint getPoint2() {
        return this.point2;
    }

    public void setPoint2(Waypoint point2) {
        this.point2 = point2;
    }

    public String toString() {
        return String.format("Wayline [point1=%s, point2=%s, alignment=%s, wayline=%s]", this.point1, this.point2, this.alignment, this.wayline);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public Wayline getWayline() {
        return this.wayline;
    }

    public void setWayline(Wayline wayline) {
        this.wayline = wayline;
    }
}

