/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.model;

import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.dungeonsengine.model.Boundary;
import com.someguyssoftware.dungeonsengine.model.ILevel;
import com.someguyssoftware.dungeonsengine.model.IRoom;
import com.someguyssoftware.gottschcore.positional.BBox;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class Level
implements ILevel {
    private int id;
    private String name;
    private ICoords spawnPoint;
    private ICoords startPoint;
    private IRoom start;
    private IRoom end;
    private List<IRoom> rooms;
    private Boundary boundary;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private ILevelConfig config;

    public Level() {
    }

    @Override
    public IRoom getStart() {
        return this.start;
    }

    @Override
    public void setStart(IRoom start) {
        this.start = start;
    }

    @Override
    public IRoom getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(IRoom end) {
        this.end = end;
    }

    @Override
    public List<IRoom> getRooms() {
        if (this.rooms == null) {
            this.rooms = new ArrayList<IRoom>();
        }
        return this.rooms;
    }

    @Override
    public void setRooms(List<IRoom> rooms) {
        this.rooms = rooms;
    }

    public Level(IRoom start, IRoom end, List<IRoom> rooms) {
        this.start = start;
        this.end = end;
        this.rooms = rooms;
    }

    @Override
    public BBox getBoundingBox() {
        BlockPos bp1 = this.getStartPoint().toPos();
        BlockPos bp2 = this.getStartPoint().add(this.getWidth(), this.getStartPoint().getY() + 1, this.getDepth()).toPos();
        AxisAlignedBB bb = new AxisAlignedBB(bp1, bp2);
        return new BBox(bb);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public void setMinX(int minX) {
        this.minX = minX;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public void setMinY(int minY) {
        this.minY = minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    @Override
    public int getMinZ() {
        return this.minZ;
    }

    @Override
    public void setMinZ(int minZ) {
        this.minZ = minZ;
    }

    @Override
    public int getMaxZ() {
        return this.maxZ;
    }

    @Override
    public void setMaxZ(int maxZ) {
        this.maxZ = maxZ;
    }

    @Override
    public ICoords getStartPoint() {
        return this.startPoint;
    }

    @Override
    public void setStartPoint(ICoords startPoint) {
        this.startPoint = startPoint;
    }

    @Override
    public ILevelConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ILevelConfig config) {
        this.config = config;
    }

    @Override
    public ICoords getSpawnPoint() {
        return this.spawnPoint;
    }

    @Override
    public void setSpawnPoint(ICoords spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public int getDepth() {
        return this.getBoundary().getMaxCoords().getZ() - this.getBoundary().getMinCoords().getZ();
    }

    @Override
    public int getWidth() {
        return this.getBoundary().getMaxCoords().getX() - this.getBoundary().getMinCoords().getX();
    }

    @Override
    public Boundary getBoundary() {
        return this.boundary;
    }

    @Override
    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }
}

