/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.model;

import com.someguyssoftware.dungeonsengine.enums.RoomTag;
import com.someguyssoftware.dungeonsengine.model.AbstractSpace;
import com.someguyssoftware.dungeonsengine.model.IExit;
import com.someguyssoftware.dungeonsengine.model.IRoom;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.List;

public class Room
extends AbstractSpace
implements IRoom {
    private int id;
    private String name;
    private Direction direction;
    List<RoomTag> tags;
    private int degrees;

    public Room() {
    }

    public Room(IRoom space) {
        if (space != null) {
            this.setID(space.getID());
        }
    }

    @Override
    public IRoom copy() {
        return new Room(this);
    }

    @Override
    public void centerOn(ICoords coords) {
        this.setCoords((ICoords)new Coords(coords.getX() - this.getWidth() / 2, coords.getY(), coords.getZ() - this.getDepth() / 2));
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public IRoom setID(int id) {
        this.id = id;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRoom setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public IRoom setDimensions(int width, int height, int depth) {
        this.setWidth(width);
        this.setHeight(height);
        this.setDepth(depth);
        return this;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public IRoom setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public int getDegrees() {
        return this.degrees;
    }

    @Override
    public IRoom setDegrees(int degrees) {
        this.degrees = degrees;
        return this;
    }

    @Override
    public List<RoomTag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<RoomTag>();
        }
        return this.tags;
    }

    @Override
    public void setTags(List<RoomTag> tags) {
        this.tags = tags;
    }

    @Override
    public boolean isAnchor() {
        return this.getTags().contains((Object)RoomTag.ANCHOR);
    }

    @Override
    public IRoom setAnchor(boolean anchor) {
        if (anchor) {
            if (!this.getTags().contains((Object)RoomTag.ANCHOR)) {
                this.getTags().add(RoomTag.ANCHOR);
            } else if (this.getTags().contains((Object)RoomTag.ANCHOR)) {
                this.getTags().remove((Object)RoomTag.ANCHOR);
            }
        }
        return this;
    }

    @Override
    public boolean isStart() {
        return this.getTags().contains((Object)RoomTag.START);
    }

    @Override
    public IRoom setStart(boolean start) {
        if (start) {
            if (!this.getTags().contains((Object)RoomTag.START)) {
                this.getTags().add(RoomTag.START);
            } else if (this.getTags().contains((Object)RoomTag.START)) {
                this.getTags().remove((Object)RoomTag.START);
            }
        }
        return this;
    }

    @Override
    public boolean isEnd() {
        return this.getTags().contains((Object)RoomTag.END);
    }

    @Override
    public IRoom setEnd(boolean end) {
        if (end) {
            if (!this.getTags().contains((Object)RoomTag.END)) {
                this.getTags().add(RoomTag.END);
            } else if (this.getTags().contains((Object)RoomTag.END)) {
                this.getTags().remove((Object)RoomTag.END);
            }
        }
        return this;
    }

    @Override
    public boolean isObstacle() {
        return this.getTags().contains((Object)RoomTag.OBSTACLE);
    }

    @Override
    public IRoom setObstacle(boolean obstacle) {
        if (obstacle) {
            if (!this.getTags().contains((Object)RoomTag.OBSTACLE)) {
                this.getTags().add(RoomTag.OBSTACLE);
            } else if (this.getTags().contains((Object)RoomTag.OBSTACLE)) {
                this.getTags().remove((Object)RoomTag.OBSTACLE);
            }
        }
        return this;
    }

    @Override
    public List<IExit> getExits() {
        return this.exits;
    }

    @Override
    public void setExits(List<IExit> exits) {
        this.exits = exits;
    }

    public String toString() {
        return String.format("Room [\n\tid=%s, \n\tname=%s, \n\tcoords=%s, \n\tdepth=%s, \n\twidth=%s, \n\theight=%s, \n\tdirection=%s, \n\ttags=%s, \n\tdegrees=%s, \n\texits=%s]", this.id, this.name, this.coords, this.depth, this.width, this.height, this.direction, this.tags, this.degrees, this.exits);
    }
}

