/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.base.Preconditions;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.component.BooleanComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PowerComponent
extends BooleanComponent {
    private final InteractionType interractionType;
    private final ComponentType componentType;
    private boolean hasDirectionalComponent = false;
    private IPowerChange onPowerChange = null;

    public PowerComponent(InteractionType interractionType, ComponentType componentType) {
        super("power", false, 3);
        this.interractionType = interractionType;
        this.componentType = componentType;
    }

    @Override
    public void onComponentAdded(IComponentProvider provider) {
        this.hasDirectionalComponent = IComponent.getComponent(DirectionalComponent.class, provider) != null;
    }

    @Override
    public boolean onBlockActivated(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.interractionType == InteractionType.REDSTONE) {
            return false;
        }
        boolean isPowered = this.invert(world, pos);
        if (this.hasDirectionalComponent) {
            world.func_175685_c(pos.func_177972_a(DirectionalComponent.getDirection(state).func_176734_d()), block, true);
        }
        if (this.onPowerChange != null) {
            this.onPowerChange.powerChanged(world, pos, isPowered);
        }
        return true;
    }

    @Override
    public void onNeighborBlockChange(Block block, World world, BlockPos pos, IBlockState state, Block neighborBlock, BlockPos neighborPos) {
        if (this.interractionType == InteractionType.RIGHT_CLICK || this.componentType == ComponentType.PROVIDER || !neighborBlock.func_176223_P().func_185897_m()) {
            return;
        }
        boolean isPowered = this.get((IBlockAccess)world, pos);
        this.set(world, pos, world.func_175640_z(pos));
        if (this.onPowerChange != null && isPowered != this.get((IBlockAccess)world, pos)) {
            this.onPowerChange.powerChanged(world, pos, !isPowered);
        }
    }

    @Override
    public boolean canProvidePower(Block block, IBlockState state) {
        return this.componentType != ComponentType.RECEIVER;
    }

    @Override
    public void breakBlock(Block block, World world, BlockPos pos, IBlockState state) {
        if (this.componentType == ComponentType.RECEIVER || !PowerComponent.isPowered(state)) {
            return;
        }
        world.func_175685_c(pos, block, true);
        if (IComponent.getComponent(DirectionalComponent.class, block) != null) {
            world.func_175685_c(pos.func_177972_a(DirectionalComponent.getDirection(state).func_176734_d()), block, true);
        }
    }

    public void onPowerChange(IPowerChange onPowerChange) {
        this.onPowerChange = (IPowerChange)Preconditions.checkNotNull((Object)onPowerChange);
    }

    public static boolean isPowered(World world, BlockPos pos) {
        return PowerComponent.isPowered(world.func_180495_p(pos));
    }

    public static boolean isPowered(IBlockState state) {
        PowerComponent pc = IComponent.getComponent(PowerComponent.class, state.func_177230_c());
        if (pc == null) {
            return false;
        }
        PropertyBool property = pc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)property);
    }

    public static PropertyBool getProperty(Block block) {
        PowerComponent pc = IComponent.getComponent(PowerComponent.class, block);
        return pc != null ? pc.getProperty() : null;
    }

    @FunctionalInterface
    public static interface IPowerChange {
        public void powerChanged(World var1, BlockPos var2, boolean var3);
    }

    public static enum ComponentType {
        PROVIDER,
        RECEIVER,
        BOTH,
        NONE;

    }

    public static enum InteractionType {
        RIGHT_CLICK,
        REDSTONE,
        BOTH;

    }
}

