/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.dorkbox.tweenEngine.pool;

import java.util.Queue;
import net.aeronica.dorkbox.tweenEngine.pool.PoolableObject;

public class ObjectPool<T> {
    protected final Queue queue;
    protected final PoolableObject poolableObject;

    public ObjectPool(PoolableObject poolableObject, Queue queue) {
        this.poolableObject = poolableObject;
        this.queue = queue;
    }

    public T take() {
        Object take = this.queue.poll();
        if (take == null) {
            take = this.poolableObject.create();
        }
        return (T)take;
    }

    public void put(T object) {
        this.poolableObject.onReturn(object);
        this.queue.offer(object);
    }
}

