/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client;

import com.google.common.collect.ImmutableMap;
import net.aeronica.mods.bard_mania.client.KeyHelper;
import net.aeronica.mods.bard_mania.client.MidiHelper;
import net.aeronica.mods.bard_mania.client.actions.base.ActionManager;
import net.aeronica.mods.bard_mania.client.audio.NoteSound;
import net.aeronica.mods.bard_mania.client.audio.SoundHelper;
import net.aeronica.mods.bard_mania.client.gui.InputModeToast;
import net.aeronica.mods.bard_mania.client.render.LayerWearableInstrument;
import net.aeronica.mods.bard_mania.server.ModConfig;
import net.aeronica.mods.bard_mania.server.ServerProxy;
import net.aeronica.mods.bard_mania.server.init.ModSoundEvents;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ClientProxy
extends ServerProxy {
    @Override
    public void setNoteReceiver(String soundName) {
        if (ModConfig.client.input_mode == ModConfig.Client.INPUT_MODE.MIDI) {
            MidiHelper.INSTANCE.setMidiNoteReceiver(soundName);
        } else {
            MidiHelper.INSTANCE.setKeyboardNoteReceiver(soundName);
        }
    }

    @Override
    public void notifyRemoved(String message) {
        MidiHelper.INSTANCE.notifyRemoved(message);
    }

    @Override
    public void notifyRemoved(ItemStack stackIn) {
        MidiHelper.INSTANCE.notifyRemoved(stackIn);
    }

    @Override
    public void playSound(EntityPlayer playerIn, byte noteIn, byte volumeIn) {
        WorldClient worldClient = (WorldClient)playerIn.func_130014_f_();
        ItemStack heldItem = playerIn.func_184614_ca();
        Instrument instrument = ((ItemInstrument)heldItem.func_77973_b()).getInstrument();
        if (volumeIn == 0 && SoundHelper.shouldSendNoteOff(instrument.sounds.timbre)) {
            SoundHelper.noteOff((EntityLivingBase)playerIn, noteIn);
            return;
        }
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemInstrument && !this.getMinecraft().func_147113_T()) {
            this.getMinecraft().func_147118_V().func_147682_a((ISound)new NoteSound((EntityLivingBase)playerIn, ModSoundEvents.getSound(instrument.sounds.timbre), noteIn, KeyHelper.calculatePitch(noteIn), 1.0f + (float)(volumeIn / 127), false));
            worldClient.func_175688_a(EnumParticleTypes.NOTE, playerIn.field_70165_t + worldClient.field_73012_v.nextDouble() * 0.5 - 0.25, playerIn.field_70163_u + 2.5, playerIn.field_70161_v + worldClient.field_73012_v.nextDouble() * 0.5 - 0.25, (double)KeyHelper.normalizeNote(noteIn) / 24.0, 0.0, 0.0, new int[0]);
            ActionManager.playAction(playerIn, noteIn);
            SoundHelper.stopBackgroundMusic();
        }
    }

    @Override
    public void playSound(EntityPlayer playerIn, int entityId, String soundName, byte noteIn, byte volumeIn) {
        WorldClient worldClient = (WorldClient)playerIn.func_130014_f_();
        EntityPlayer playingPlayer = (EntityPlayer)worldClient.func_73045_a(entityId);
        if (volumeIn == 0 && SoundHelper.shouldSendNoteOff(soundName)) {
            SoundHelper.noteOff((EntityLivingBase)playingPlayer, noteIn);
            return;
        }
        if (playingPlayer != null && playerIn.func_145782_y() != entityId && !this.getMinecraft().func_147113_T()) {
            this.getMinecraft().func_147118_V().func_147682_a((ISound)new NoteSound((EntityLivingBase)playingPlayer, ModSoundEvents.getSound(soundName), noteIn, KeyHelper.calculatePitch(noteIn), 1.0f + (float)(volumeIn / 127), true));
            worldClient.func_175688_a(EnumParticleTypes.NOTE, playingPlayer.field_70165_t + worldClient.field_73012_v.nextDouble() * 0.5 - 0.25, playingPlayer.field_70163_u + 2.5, playingPlayer.field_70161_v + worldClient.field_73012_v.nextDouble() * 0.5 - 0.25, (double)KeyHelper.normalizeNote(noteIn) / 24.0, 0.0, 0.0, new int[0]);
            ActionManager.playAction(playingPlayer, noteIn);
            SoundHelper.stopBackgroundMusic();
        }
    }

    @Override
    public void postInputModeToast(ItemStack itemStack) {
        this.getMinecraft().func_193033_an().func_192988_a((IToast)new InputModeToast(itemStack));
    }

    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        LayerWearableInstrument.addLayer();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void spawnTimpaniParticle(World world, double x, double y, double z) {
    }

    @Override
    public void spawnRopeParticle(World world, double x, double y, double z) {
    }

    @Override
    public Side getPhysicalSide() {
        return Side.CLIENT;
    }

    @Override
    public Side getEffectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    @Override
    public Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public World getWorldByDimensionId(int dimension) {
        Side effectiveSide = FMLCommonHandler.instance().getEffectiveSide();
        if (effectiveSide == Side.SERVER) {
            return FMLClientHandler.instance().getServer().func_71218_a(dimension);
        }
        return this.getClientWorld();
    }

    @Override
    public boolean playerIsInCreativeMode(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            return entityPlayerMP.func_184812_l_();
        }
        if (player instanceof EntityPlayerSP) {
            return Minecraft.func_71410_x().field_71442_b.func_78758_h();
        }
        return false;
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? this.getMinecraft() : super.getThreadFromContext(ctx);
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? this.getClientPlayer() : super.getPlayerEntity(ctx);
    }

    @Override
    public IAnimationStateMachine load(ResourceLocation location, ImmutableMap<String, ITimeValue> parameters) {
        return ModelLoaderRegistry.loadASM((ResourceLocation)location, parameters);
    }
}

