/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KeyHelper {
    public static final int MIDI_NOTE_LOW = 48;
    public static final int MIDI_NOTE_HIGH = 72;
    public static final Integer[][] KEYNOTE_VALUES = new Integer[][]{{44, 0}, {31, 1}, {45, 2}, {32, 3}, {46, 4}, {47, 5}, {34, 6}, {48, 7}, {35, 8}, {49, 9}, {36, 10}, {50, 11}, {51, 12}, {16, 12}, {3, 13}, {17, 14}, {4, 15}, {18, 16}, {19, 17}, {6, 18}, {20, 19}, {7, 20}, {21, 21}, {8, 22}, {22, 23}, {23, 24}};
    private static final Map<Integer, Integer> keyNoteMap;

    private KeyHelper() {
    }

    public static boolean hasKey(int scanCode) {
        return keyNoteMap.containsKey(scanCode);
    }

    public static int getKey(int scanCode) {
        return keyNoteMap.get(scanCode);
    }

    public static boolean hasNote(int midiNote) {
        return keyNoteMap.containsValue(midiNote);
    }

    public static boolean isMidiNoteInRange(byte midiNote) {
        return midiNote >= 48 && midiNote <= 72;
    }

    public static int normalizeNote(int noteIn) {
        return Math.max(noteIn - 48, 0);
    }

    public static float calculatePitch(byte noteIn) {
        return (float)Math.pow(2.0, (double)(KeyHelper.normalizeNote(noteIn) - 12) / 12.0);
    }

    static {
        HashMap<Integer, Integer> aMap = new HashMap<Integer, Integer>();
        for (Integer[] key : KEYNOTE_VALUES) {
            aMap.put(key[0], key[1] + 48);
        }
        keyNoteMap = Collections.unmodifiableMap(aMap);
    }
}

