/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.actions;

import net.aeronica.dorkbox.tweenEngine.Timeline;
import net.aeronica.dorkbox.tweenEngine.TweenEngine;
import net.aeronica.dorkbox.tweenEngine.TweenEquations;
import net.aeronica.mods.bard_mania.client.actions.base.ModelDummy;
import net.minecraft.entity.player.EntityPlayer;

public class RecorderTimeLines {
    private static final float TARGET_RIGHT_ARM_POSE_ROT_X = -0.87f;
    private static final float TARGET_RIGHT_ARM_POSE_ROT_Y = -0.47f;
    private static final float TARGET_LEFT_ARM_POSE_ROT_X = -1.12f;
    private static final float TARGET_LEFT_ARM_POSE_ROT_Y = 0.47f;
    private static final float TARGET_HEAD_POSE_ROT_Y = 0.698f;
    private static final float TARGET_HEAD_POSE_ROT_X = 0.175f;
    private static final float TARGET_PLAYER_POSE_ROTATION_YAW = 40.0f;
    private static final float TARGET_WORN_ITEM_SCALE = 1.0f;
    private static final int[] rightHandFingering = new int[]{0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1};
    private static final int[] leftHandFingering = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1};

    private RecorderTimeLines() {
    }

    public static Timeline apply(EntityPlayer playerIn, TweenEngine tweenEngine, Timeline timeline, ModelDummy modelDummy, int normalizedNote) {
        modelDummy.setPartValue(24, -0.87f);
        modelDummy.setPartValue(25, -0.47f);
        modelDummy.setPartValue(27, -1.12f);
        modelDummy.setPartValue(28, 0.47f);
        modelDummy.setPartValue(19, 0.698f);
        modelDummy.setPartValue(18, 0.175f);
        modelDummy.setPartValue(36, 40.0f);
        modelDummy.setPartValue(49, 1.0f);
        return timeline;
    }

    public static Timeline play(EntityPlayer playerIn, TweenEngine tweenEngine, Timeline timeline, ModelDummy modelDummy, int normalizedNote) {
        Timeline localTimeLine = timeline.beginParallel();
        localTimeLine = localTimeLine.push(tweenEngine.to(modelDummy, 0, 0.15f).target(-0.044f).ease(TweenEquations.Sine_InOut).ease(TweenEquations.Sine_InOut));
        if (RecorderTimeLines.rightOpenHole(normalizedNote)) {
            localTimeLine = localTimeLine.push(tweenEngine.to(modelDummy, 7, 0.15f).target(-0.05f).ease(TweenEquations.Sine_InOut).ease(TweenEquations.Sine_InOut));
        }
        if (RecorderTimeLines.leftOpenHole(normalizedNote)) {
            localTimeLine = localTimeLine.push(tweenEngine.to(modelDummy, 10, 0.15f).target(0.05f).ease(TweenEquations.Sine_InOut).ease(TweenEquations.Sine_InOut));
        }
        localTimeLine = localTimeLine.end().beginParallel();
        localTimeLine = localTimeLine.push(tweenEngine.to(modelDummy, 0, 0.55f).target(0.0f).ease(TweenEquations.Sine_InOut).ease(TweenEquations.Sine_InOut));
        if (RecorderTimeLines.rightOpenHole(normalizedNote)) {
            localTimeLine = localTimeLine.push(tweenEngine.to(modelDummy, 7, 0.35f).target(0.0f).ease(TweenEquations.Sine_InOut));
        }
        if (RecorderTimeLines.leftOpenHole(normalizedNote)) {
            localTimeLine = localTimeLine.push(tweenEngine.to(modelDummy, 10, 0.35f).target(0.0f).ease(TweenEquations.Sine_InOut));
        }
        localTimeLine = localTimeLine.end();
        return localTimeLine;
    }

    public static Timeline equip(EntityPlayer playerIn, TweenEngine tweenEngine, Timeline timeline, ModelDummy modelDummy, int normalizedNote) {
        timeline.beginParallel().push(tweenEngine.to(modelDummy, 24, 0.25f).target(-0.87f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 25, 0.25f).target(-0.47f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 27, 0.25f).target(-1.12f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 28, 0.25f).target(0.47f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 38, 0.25f).target(-0.4f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 39, 0.25f).target(-0.15f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 40, 0.25f).target(11.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 41, 0.25f).target(-10.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 19, 0.25f).target(0.698f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 18, 0.25f).target(0.175f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 36, 0.25f).target(40.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 49, 0.5f).target(1.0f).ease(TweenEquations.Bounce_InOut)).end();
        return timeline;
    }

    public static Timeline remove(EntityPlayer playerIn, TweenEngine tweenEngine, Timeline timeline, ModelDummy modelDummy, int normalizedNote) {
        timeline.beginParallel().push(tweenEngine.to(modelDummy, 24, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 25, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 27, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 28, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 38, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 39, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 40, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 41, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 36, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).push(tweenEngine.to(modelDummy, 49, 0.25f).target(0.0f).ease(TweenEquations.Sine_InOut)).end();
        return timeline;
    }

    private static boolean isEvenNote(int normalizedNote) {
        return normalizedNote % 2 == 0;
    }

    private static boolean rightOpenHole(int normalizedNote) {
        return normalizedNote >= 0 && normalizedNote <= 24 && rightHandFingering[normalizedNote] == 1;
    }

    private static boolean leftOpenHole(int normalizedNote) {
        return normalizedNote >= 0 && normalizedNote <= 24 && leftHandFingering[normalizedNote] == 1;
    }

    private static float rightHandNotePosition(int normalizedNote) {
        return (float)(normalizedNote - 24) * 0.2f / 24.0f + 0.2f;
    }

    private static float leftHandNotePosition(int normalizedNote) {
        return (float)(normalizedNote - 24) * 0.2f / 24.0f + 0.2f;
    }
}

