/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.actions.base;

import net.aeronica.dorkbox.tweenEngine.TweenEngine;
import net.aeronica.mods.bard_mania.client.KeyHelper;
import net.aeronica.mods.bard_mania.client.actions.base.ModelAccessor;
import net.aeronica.mods.bard_mania.client.actions.base.ModelDummy;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.entity.player.EntityPlayer;

public abstract class ActionBase {
    private static final int TIME_TO_LIVE = 1024;
    protected EntityPlayer player;
    protected ModelDummy modelDummy;
    protected boolean isDone;
    protected boolean isStarted;
    protected Instrument instrument;
    protected String instrumentId;
    protected int normalizedNote;
    private int timeToLive;
    protected TweenEngine tweenEngine = TweenEngine.create().unsafe().setWaypointsLimit(10).setCombinedAttributesLimit(1).registerAccessor(ModelDummy.class, new ModelAccessor()).build();

    public ActionBase(EntityPlayer playerIn, ModelDummy modelDummy, int noteIn) {
        this.player = playerIn;
        this.modelDummy = modelDummy;
        this.normalizedNote = KeyHelper.normalizeNote(noteIn);
        this.isDone = false;
        this.isStarted = false;
        this.timeToLive = 1024;
        if (!this.player.func_184614_ca().func_190926_b() && this.player.func_184614_ca().func_77973_b() instanceof ItemInstrument) {
            this.instrument = ((ItemInstrument)this.player.func_184614_ca().func_77973_b()).getInstrument();
            this.instrumentId = this.instrument.id;
        } else {
            this.instrumentId = "dead_beef";
            this.isDone = true;
        }
    }

    protected abstract void start();

    private void processStart() {
        if (!this.isStarted && this.instrument != null) {
            this.start();
            this.isStarted = true;
        }
    }

    public void update(float deltaTime) {
        this.processStart();
        this.testTTL();
        this.tweenEngine.update(deltaTime);
    }

    private void testTTL() {
        if (this.timeToLive-- < 0) {
            this.isDone = true;
        }
    }

    public ModelDummy getModelDummy() {
        return this.modelDummy;
    }

    public boolean isDone() {
        return this.isDone || this.player.field_70733_aJ > 0.0f || this.player.field_70737_aN > 0;
    }
}

