/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.audio;

import java.nio.IntBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aeronica.mods.bard_mania.client.actions.base.ActionManager;
import net.aeronica.mods.bard_mania.client.audio.NoteSound;
import net.aeronica.mods.bard_mania.server.ModConfig;
import net.aeronica.mods.bard_mania.server.ModLogger;
import net.aeronica.mods.bard_mania.server.init.ModSoundEvents;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class SoundHelper {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static SoundSystem sndSystem = null;
    private static SoundHandler handler;
    private static SoundManager sndManager;
    private static MusicTicker musicTicker;
    private static boolean backgroundMusicPaused;
    private static int counter;
    private static Map<String, Integer> uuidEntityId;
    private static Map<String, Integer> uuidNote;
    private static final int MAX_STREAM_CHANNELS = 16;
    private static final int DESIRED_STREAM_CHANNELS = 12;

    public static void noteOff(EntityLivingBase livingEntity, int midiNote) {
        for (String uuid : uuidNote.keySet()) {
            if (uuidNote.get(uuid) != midiNote || uuidEntityId.get(uuid).intValue() != livingEntity.func_145782_y()) continue;
            SoundHelper.stopNote(uuid);
            return;
        }
    }

    public static void stopNotes(EntityLivingBase entityLivingBase) {
        int entityId = entityLivingBase.func_145782_y();
        for (String uuid : uuidEntityId.keySet()) {
            if (entityId != uuidEntityId.get(uuid)) continue;
            SoundHelper.stopNote(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopNote(String uuid) {
        Object object = SoundSystemConfig.THREAD_SYNC;
        synchronized (object) {
            if (uuidNote.containsKey(uuid)) {
                sndSystem.fadeOut(uuid, null, 150L);
            }
            uuidNote.remove(uuid);
            uuidEntityId.remove(uuid);
        }
    }

    private static void init() {
        if (sndSystem == null || SoundHelper.sndSystem.randomNumberGenerator == null) {
            handler = Minecraft.func_71410_x().func_147118_V();
            sndManager = SoundHelper.handler.field_147694_f;
            sndSystem = SoundHelper.sndManager.field_148620_e;
            musicTicker = Minecraft.func_71410_x().func_181535_r();
            SoundHelper.setBackgroundMusicPaused(false);
        }
    }

    public static boolean shouldSendNoteOff(String soundName) {
        return mc.func_147118_V().func_184398_a(ModSoundEvents.getSound(soundName).func_187503_a()).func_148720_g().func_188723_h();
    }

    @SubscribeEvent
    public static void onEvent(PlaySoundEvent event) {
        if (event.getSound() instanceof NoteSound) {
            SoundHelper.init();
        }
    }

    @SubscribeEvent
    public static void PlayStreamingSourceEvent(PlayStreamingSourceEvent event) {
        if (event.getSound() instanceof NoteSound) {
            NoteSound sound = (NoteSound)event.getSound();
            sound.setUuid(event.getUuid());
            uuidNote.put(event.getUuid(), sound.getMidiNote());
            uuidEntityId.put(event.getUuid(), sound.getEntityId());
        }
    }

    @SubscribeEvent
    public static void soundSetupEvent(SoundSetupEvent event) {
        SoundHelper.configureSound();
    }

    private static void alErrorCheck() {
        int error = AL10.alGetError();
        if (error != 0) {
            ModLogger.warn("OpenAL error: %d", error);
        }
    }

    private static void configureSound() {
        int streamChannelCount;
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
                SoundHelper.alErrorCheck();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            SoundHelper.alErrorCheck();
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            ModLogger.error(e);
        }
        int normalChannelCount = SoundSystemConfig.getNumberNormalChannels();
        if (ModConfig.getAutoConfigureChannels() && totalChannels > 64 && streamChannelCount < 12) {
            totalChannels = (totalChannels + 1) * 3 / 4;
            streamChannelCount = Math.min(Math.min(totalChannels / 5, 16), 12);
            normalChannelCount = totalChannels - streamChannelCount;
        } else if (totalChannels != -1 && normalChannelCount + streamChannelCount >= 32) {
            for (streamChannelCount = SoundSystemConfig.getNumberStreamingChannels(); streamChannelCount < 6 && normalChannelCount > 24; --normalChannelCount, ++streamChannelCount) {
            }
        }
        ModLogger.info("Sound channels: %d normal, %d streaming (total avail: %s)", normalChannelCount, streamChannelCount, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels));
        SoundSystemConfig.setNumberNormalChannels((int)normalChannelCount);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannelCount);
    }

    private static void stopMusic() {
        if (sndSystem != null && SoundHelper.musicTicker.field_147678_c != null) {
            handler.func_147683_b(SoundHelper.musicTicker.field_147678_c);
            SoundHelper.musicTicker.field_147678_c = null;
            SoundHelper.setBackgroundMusicTimer(0);
        }
    }

    public static void stopBackgroundMusic() {
        if (SoundHelper.isBackgroundMusicPaused()) {
            return;
        }
        SoundHelper.setBackgroundMusicPaused(true);
        SoundHelper.stopMusic();
        SoundHelper.setBackgroundMusicTimer(Integer.MAX_VALUE);
    }

    private static void resumeBackgroundMusic() {
        SoundHelper.setBackgroundMusicTimer(500);
    }

    private static void setBackgroundMusicTimer(int value) {
        if (sndSystem != null) {
            SoundHelper.musicTicker.field_147676_d = value;
        }
    }

    private static void setBackgroundMusicPaused(boolean pause) {
        backgroundMusicPaused = pause;
    }

    private static boolean isBackgroundMusicPaused() {
        return backgroundMusicPaused;
    }

    public static void updateBackgroundMusicPausing() {
        if (sndSystem != null && counter++ % 80 == 0) {
            if (SoundHelper.isBackgroundMusicPaused() && ActionManager.getActionsCount() == 0) {
                SoundHelper.resumeBackgroundMusic();
                SoundHelper.setBackgroundMusicPaused(false);
            } else if (ActionManager.getActionsCount() > 0) {
                SoundHelper.setBackgroundMusicTimer(Integer.MAX_VALUE);
            }
        }
    }

    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (SoundHelper.mc.field_71474_y.field_74330_P) {
            return;
        }
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && SoundHelper.mc.field_71439_g.func_184614_ca().func_77973_b() instanceof ItemInstrument) {
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b() - 40;
            int x = 130;
            int y = 22;
            if (sndSystem != null && SoundHelper.sndManager.field_148629_h != null) {
                SoundHelper.mc.field_71466_p.func_175063_a(String.format("Sound count    : %03d", SoundHelper.sndManager.field_148629_h.size()), (float)x, (float)(y += 10), 0xD0D0D0);
            }
            SoundHelper.mc.field_71466_p.func_175063_a(String.format("Sound notes    : %03d", uuidNote.size()), (float)x, (float)(y += 10), 0xD0D0D0);
            SoundHelper.mc.field_71466_p.func_175063_a(String.format("Tween count    : %03d", ActionManager.getTweenCount((EntityPlayer)SoundHelper.mc.field_71439_g)), (float)x, (float)(y += 10), 0xD0D0D0);
            SoundHelper.mc.field_71466_p.func_175063_a(String.format("Back paused    : %s", SoundHelper.isBackgroundMusicPaused()), (float)x, (float)(y += 10), 0xD0D0D0);
        }
    }

    static {
        backgroundMusicPaused = false;
        counter = 0;
        uuidEntityId = new ConcurrentHashMap<String, Integer>();
        uuidNote = new ConcurrentHashMap<String, Integer>();
    }
}

