/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.gui;

import java.io.IOException;
import net.aeronica.mods.bard_mania.client.KeyHelper;
import net.aeronica.mods.bard_mania.client.MidiHelper;
import net.aeronica.mods.bard_mania.client.audio.SoundHelper;
import net.aeronica.mods.bard_mania.client.gui.GuiKeyButton;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.aeronica.mods.bard_mania.server.network.server.GuiClosedMessage;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiKeyboard
extends GuiScreen {
    public static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("bard_mania", "textures/gui/gui_player_background.png");
    private static final String KEY_TOPS = "ZSXDCVGBHNJM,Q2W3ER5T6Y7UI";
    private static int[] SHARPES = new int[]{1, 3, -1, 6, 8, 10};
    private static int[] NATURAL = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
    private String TITLE = I18n.func_135052_a((String)"gui.bard_mania.gui_keyboard.title", (Object[])new Object[0]);
    private boolean sendNoteOff;
    private GuiKeyButton exit;

    public void func_73866_w_() {
        Instrument inst = ((ItemInstrument)this.field_146297_k.field_71439_g.func_184614_ca().func_77973_b()).getInstrument();
        this.sendNoteOff = SoundHelper.shouldSendNoteOff(inst.sounds.timbre);
        this.field_146292_n.clear();
        int centerNatural = (this.field_146294_l - 208 - 100) / 2;
        int centerSharpes = centerNatural + 12;
        this.makeGuiKeys(centerSharpes, 30, SHARPES, true);
        this.makeGuiKeys(centerNatural, 56, NATURAL, true);
        this.makeGuiKeys(centerSharpes, 82, SHARPES, false);
        this.makeGuiKeys(centerNatural, 108, NATURAL, false);
        this.exit = new GuiKeyButton(9999, centerNatural + 52, 138, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.func_189646_b(this.exit);
        super.func_73866_w_();
    }

    public void func_146281_b() {
        Minecraft.func_71410_x().func_152344_a(() -> {
            SoundHelper.stopNotes((EntityLivingBase)this.field_146297_k.field_71439_g);
            PacketDispatcher.sendToServer(new GuiClosedMessage(0));
            MidiHelper.INSTANCE.notifyRemoved("Gui Keyboard Closed");
        });
        super.func_146281_b();
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawGuiPlayerBackgroundLayer(partialTicks, mouseX, mouseY, (this.field_146294_l + 208 - 100) / 2, 20);
        int posX = (this.field_146294_l - this.getFontRenderer().func_78256_a(this.TITLE)) / 2;
        int posY = 10;
        this.getFontRenderer().func_175063_a(this.TITLE, (float)posX, (float)posY, 0xD3D3D3);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void drawGuiPlayerBackgroundLayer(float partialTicks, int mouseX, int mouseY, int xIn, int yIn) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BACKGROUND);
        int i = xIn + 50;
        int j = 128;
        this.func_73729_b(xIn, yIn, 0, 0, 100, 120);
        GuiInventory.func_147046_a((int)i, (int)j, (int)50, (float)((float)xIn - (float)xIn + 10.0f), (float)((float)yIn - (float)yIn - 10.0f), (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (KeyHelper.hasKey(button.field_146127_k)) {
            this.sendNote(KeyHelper.getKey(button.field_146127_k), false);
        }
        if (button.field_146127_k == 9999) {
            this.func_73869_a('\u0001', 1);
        }
        super.func_146284_a(button);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.field_146290_a != null && state == 0) {
            if (KeyHelper.hasKey(this.field_146290_a.field_146127_k) && this.sendNoteOff) {
                this.sendNote(KeyHelper.getKey(this.field_146290_a.field_146127_k), true);
            }
            this.field_146290_a.func_146118_a(mouseX, mouseY);
            this.field_146290_a = null;
        }
    }

    public void func_146282_l() throws IOException {
        char c0 = Keyboard.getEventCharacter();
        if (c0 >= ' ' && Keyboard.getEventKeyState()) {
            this.keyDown(c0, Keyboard.getEventKey());
        }
        if (!Keyboard.getEventKeyState()) {
            this.keyUp(c0, Keyboard.getEventKey());
        }
        super.func_146282_l();
    }

    private void keyDown(char c0, int keyCode) {
        if (KeyHelper.hasKey(keyCode) && !Keyboard.isRepeatEvent()) {
            this.sendNote(KeyHelper.getKey(keyCode), false);
        }
    }

    private void keyUp(char c0, int keyCode) {
        if (KeyHelper.hasKey(keyCode) && this.sendNoteOff) {
            this.sendNote(KeyHelper.getKey(keyCode), true);
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
    }

    public boolean func_73868_f() {
        return false;
    }

    private void sendNote(int note, boolean off) {
        MidiHelper.send((byte)note, (byte)(off ? 0 : 64), 5L);
    }

    private FontRenderer getFontRenderer() {
        return this.field_146297_k.field_71466_p;
    }

    private void makeGuiKeys(int xIn, int yIn, int[] keyType, boolean raiseOctave) {
        int x = xIn;
        for (int i : keyType) {
            if (i >= 0) {
                if (raiseOctave) {
                    i += 13;
                }
                this.field_146292_n.add(new GuiKeyButton(KeyHelper.KEYNOTE_VALUES[i][0], x, yIn, 20, 20, I18n.func_135052_a((String)("gui.bard_mania.gui_key_" + (KEY_TOPS.subSequence(i, i + 1).equals(",") ? "COMMA" : KEY_TOPS.subSequence(i, i + 1))), (Object[])new Object[0])));
            }
            x += 26;
        }
    }
}

