/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.bard_mania.client.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import net.aeronica.mods.bard_mania.BardMania;
import net.aeronica.mods.bard_mania.client.KeyHelper;
import net.aeronica.mods.bard_mania.client.MidiHelper;
import net.aeronica.mods.bard_mania.client.actions.base.ActionManager;
import net.aeronica.mods.bard_mania.client.audio.SoundHelper;
import net.aeronica.mods.bard_mania.client.gui.ActionGetFile;
import net.aeronica.mods.bard_mania.client.gui.ChannelSelectors;
import net.aeronica.mods.bard_mania.client.gui.MidiChooser;
import net.aeronica.mods.bard_mania.server.ModLogger;
import net.aeronica.mods.bard_mania.server.caps.BardActionHelper;
import net.aeronica.mods.bard_mania.server.item.ItemInstrument;
import net.aeronica.mods.bard_mania.server.network.PacketDispatcher;
import net.aeronica.mods.bard_mania.server.network.bi.PoseActionMessage;
import net.aeronica.mods.bard_mania.server.network.server.ActiveReceiverMessage;
import net.aeronica.mods.bard_mania.server.object.Instrument;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiPlayMidi
extends GuiScreen
implements MetaEventListener,
Receiver {
    private static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("bard_mania", "textures/gui/gui_player_background.png");
    private String TITLE = I18n.func_135052_a((String)"gui.bard_mania.gui_play_midi.title", (Object[])new Object[0]);
    private Instrument inst;
    private Sequencer sequencer = null;
    private File file = null;
    private boolean isPlaying = false;
    private double tuning = 0.0;
    private Set<Integer> channels = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3));
    private boolean allChannels = false;
    private boolean sendNoteOff;
    private ChannelSelectors selectors;
    private GuiButton equip;
    private GuiButton remove;
    private GuiButton choose;
    private GuiButton play;
    private GuiButton stop;
    private GuiSlider transpose;
    private GuiButton allOn;
    private GuiButton allOff;
    long startTime = 0L;
    long prevTime = 0L;

    GuiPlayMidi() {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.inst = ((ItemInstrument)this.field_146297_k.field_71439_g.func_184614_ca().func_77973_b()).getInstrument();
        this.sendNoteOff = SoundHelper.shouldSendNoteOff(this.inst.sounds.timbre);
        int y = 0;
        int x = 10;
        int w = 100;
        this.equip = new GuiButton(21, x, y += 20, w, 20, I18n.func_135052_a((String)"gui.bard_mania.button_equip", (Object[])new Object[0]));
        this.remove = new GuiButton(22, x, y += 20, w, 20, I18n.func_135052_a((String)"gui.bard_mania.button_remove", (Object[])new Object[0]));
        this.choose = new GuiButton(23, x, y += 20, w, 20, I18n.func_135052_a((String)"gui.bard_mania.button_choose_file", (Object[])new Object[0]));
        this.play = new GuiButton(24, x, y += 20, w, 20, I18n.func_135052_a((String)"gui.bard_mania.button_play", (Object[])new Object[0]));
        this.stop = new GuiButton(25, x, y += 20, w, 20, I18n.func_135052_a((String)"gui.bard_mania.button_stop", (Object[])new Object[0]));
        this.transpose = new GuiSlider(26, x, y += 20, w, 20, I18n.func_135052_a((String)"gui.bard_mania.slider_semitones", (Object[])new Object[0]) + " ", " \u266b", -12.0, 12.0, this.tuning, false, true);
        this.selectors = new ChannelSelectors(0, x, y);
        this.allOn = new GuiButton(27, x, y += 44, w / 2, 20, I18n.func_135052_a((String)"gui.bard_mania.button_all_on", (Object[])new Object[0]));
        this.allOff = new GuiButton(28, x += 50, y, w / 2, 20, I18n.func_135052_a((String)"gui.bard_mania.button_all_off", (Object[])new Object[0]));
        this.setButtonState(this.isPlaying);
        this.updateChannelSelectors();
        this.field_146292_n.addAll(this.selectors.getCheckBoxes());
        this.field_146292_n.add(this.equip);
        this.field_146292_n.add(this.remove);
        this.field_146292_n.add(this.choose);
        this.field_146292_n.add(this.play);
        this.field_146292_n.add(this.stop);
        this.field_146292_n.add(this.transpose);
        this.field_146292_n.add(this.allOn);
        this.field_146292_n.add(this.allOff);
    }

    public void func_146281_b() {
        this.stop();
        Minecraft.func_71410_x().func_152344_a(() -> {
            SoundHelper.stopNotes((EntityLivingBase)this.field_146297_k.field_71439_g);
            PacketDispatcher.sendToServer(new PoseActionMessage((EntityPlayer)this.field_146297_k.field_71439_g, 2, false));
            MidiHelper.INSTANCE.notifyRemoved("Play Midi Closed");
        });
        super.func_146281_b();
    }

    public void func_73876_c() {
        this.setButtonState(this.isPlaying);
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiPlayerBackgroundLayer(partialTicks, mouseX, mouseY, (this.field_146294_l + 208 - 100) / 2, 20);
        int posX = (this.field_146294_l - this.getFontRenderer().func_78256_a(this.TITLE)) / 2;
        int posY = 5;
        this.getFontRenderer().func_175063_a(this.TITLE, (float)posX, (float)posY, 0xD3D3D3);
        this.getFontRenderer().func_175063_a(I18n.func_135052_a((String)"gui.bard_mania.gui_play_midi.label_tween_count", (Object[])new Object[0]) + String.format(": %03d", ActionManager.getTweenCount((EntityPlayer)this.field_146297_k.field_71439_g)), 10.0f, (float)posY, 0xD3D3D3);
        if (ActionGetFile.INSTANCE.getFile() != null) {
            String name = ActionGetFile.INSTANCE.getFileName();
            posX = (this.field_146294_l - this.getFontRenderer().func_78256_a(name)) / 2;
            this.getFontRenderer().func_175063_a(name, (float)posX, (float)(this.field_146295_m - 50), 0xD3D3D3);
        }
        if (!GuiPlayMidi.func_146272_n()) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }
    }

    private void drawGuiPlayerBackgroundLayer(float partialTicks, int mouseX, int mouseY, int xIn, int yIn) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BACKGROUND);
        int i = xIn + 50;
        int j = 128;
        this.func_73729_b(xIn, yIn, 0, 0, 100, 120);
        GuiPlayMidi.drawEntityOnScreen(i, j, 50, (float)xIn - (float)xIn + 10.0f, (float)yIn - (float)yIn - 10.0f, (EntityLivingBase)this.field_146297_k.field_71439_g, 0.0f);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.updateChannelSelectors();
        switch (button.field_146127_k) {
            case 21: {
                PacketDispatcher.sendToServer(new PoseActionMessage((EntityPlayer)this.field_146297_k.field_71439_g, 1, false));
                break;
            }
            case 22: {
                PacketDispatcher.sendToServer(new PoseActionMessage((EntityPlayer)this.field_146297_k.field_71439_g, 2, false));
                break;
            }
            case 23: {
                new MidiChooser(ActionGetFile.INSTANCE);
                break;
            }
            case 24: {
                this.play();
                break;
            }
            case 25: {
                this.stop();
                break;
            }
            case 27: {
                this.selectors.setAll(true);
                break;
            }
            case 28: {
                this.selectors.setAll(false);
                break;
            }
        }
        super.func_146284_a(button);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        this.setButtonState(this.isPlaying);
        super.func_175273_b(mcIn, w, h);
    }

    private FontRenderer getFontRenderer() {
        return this.field_146297_k.field_71466_p;
    }

    private static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent, float playerYaw) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = playerYaw;
        ent.field_70177_z = playerYaw;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private void setButtonState(boolean state) {
        this.isPlaying = state;
        boolean isEquipped = BardActionHelper.isInstrumentEquipped((EntityPlayer)this.field_146297_k.field_71439_g);
        this.equip.field_146124_l = !this.isPlaying && !isEquipped;
        this.remove.field_146124_l = !this.isPlaying && isEquipped;
        this.choose.field_146124_l = !this.isPlaying && !isEquipped;
        this.play.field_146124_l = !this.isPlaying && isEquipped;
        this.stop.field_146124_l = this.isPlaying && isEquipped;
        this.tuning = this.transpose.getValue();
    }

    private void updateChannelSelectors() {
        this.channels = this.selectors.getChannels();
    }

    public long getSystemTime() {
        return System.nanoTime() / 1000L;
    }

    private void play() {
        if (ActionGetFile.INSTANCE.getFile() == null) {
            return;
        }
        this.setButtonState(true);
        boolean midiException = false;
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.setMasterSyncMode(Sequencer.SyncMode.INTERNAL_CLOCK);
            this.sequencer.setSlaveSyncMode(Sequencer.SyncMode.MIDI_TIME_CODE);
            this.sequencer.getTransmitter().setReceiver(this);
            this.sequencer.open();
            this.sequencer.addMetaEventListener(this);
            FileInputStream fis = new FileInputStream(ActionGetFile.INSTANCE.getFile());
            this.sequencer.setSequence(fis);
            fis.close();
            this.sequencer.setTickPosition(0L);
            this.prevTime = this.startTime = this.getSystemTime();
            this.sequencer.start();
        }
        catch (Exception e) {
            this.setButtonState(false);
            midiException = true;
        }
        finally {
            if (midiException && this.sequencer != null) {
                this.sequencer.removeMetaEventListener(this);
            }
        }
    }

    private void stop() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.setTickPosition(0L);
            this.sequencer.removeMetaEventListener(this);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                ModLogger.error(e);
                Thread.currentThread().interrupt();
            }
            this.closeMidi();
        }
    }

    private void closeMidi() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
        this.setButtonState(false);
        BardMania.proxy.notifyRemoved(this.field_146297_k.field_71439_g.func_184614_ca());
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47) {
            ModLogger.debug("MetaMessage EOS event received", new Object[0]);
            this.stop();
        }
    }

    @Override
    public void send(MidiMessage msg, long timeStamp) {
        boolean noteOffFlag;
        byte[] message = msg.getMessage();
        int command = msg.getStatus() & 0xF0;
        int channel = msg.getStatus() & 0xF;
        switch (command) {
            case 128: {
                message[2] = 0;
                break;
            }
            case 144: {
                break;
            }
            default: {
                return;
            }
        }
        boolean channelFlag = this.allChannels || this.channels.contains(channel);
        boolean bl = noteOffFlag = this.sendNoteOff || message[2] != 0;
        if (channelFlag && noteOffFlag) {
            this.startTime = this.getSystemTime();
            long ts = this.startTime - this.prevTime;
            this.prevTime = this.startTime;
            Minecraft.func_71410_x().func_152344_a(() -> this.send(message[1], message[2], ts));
        }
    }

    @Override
    public void close() {
    }

    public void send(byte noteIn, byte volume, long timeStamp) {
        byte note = this.midiWrapTranspose(noteIn);
        EntityPlayer player = BardMania.proxy.getClientPlayer();
        if (player != null && KeyHelper.isMidiNoteInRange(note)) {
            if (BardMania.proxy.getMinecraft().func_71387_A()) {
                ActiveReceiverMessage packet = new ActiveReceiverMessage(player.func_180425_c(), player.func_145782_y(), note, volume, timeStamp);
                PacketDispatcher.sendToServer(packet);
            }
            BardMania.proxy.playSound(player, note, volume);
        }
    }

    private byte midiWrapTranspose(byte midiNoteIn) {
        byte wrappedNote = (byte)(midiNoteIn + (byte)this.transpose.getValue());
        while (wrappedNote < 48 || wrappedNote > 72) {
            if (wrappedNote < 48) {
                wrappedNote = (byte)(wrappedNote + 12);
            }
            if (wrappedNote <= 72) continue;
            wrappedNote = (byte)(wrappedNote - 12);
        }
        return wrappedNote;
    }
}

